package org.exoplatform.ps.service.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.integration.notification.PSSendITBPlugin;
import org.exoplatform.ps.integration.notification.PSSendMsgPlugin;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class  SendMessageListener  extends Listener<ProjectSubEntity,String> {


    @Override
    public void onEvent(Event<ProjectSubEntity, String> event) throws Exception {
        ProjectSubEntity projectSubEntity = event.getSource();
        String poster = event.getData();

        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PSSendITBPlugin.PROJECT, projectSubEntity).append(PSSendMsgPlugin.POSTER, poster);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(PSSendMsgPlugin.ID))).execute(ctx);
    }
}
