package org.exoplatform.ps.service.util;

import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 30/01/17
 * Time: 17:55
 */
public class CSUtils {

  public static Calendar getNextDate(Calendar c, long delay) {
    Calendar next = Calendar.getInstance();
    next.setTime(c.getTime());
    next.setTimeZone(TimeZone.getTimeZone("GMT+01"));
    next.setTimeInMillis(next.getTimeInMillis()+delay);
   while((next.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) || (next.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY)){
     next.add(Calendar.DATE, 1);
   }
   return next;
  }


  public static long  getDiffBetweenTwoDates(Calendar c1, Calendar c2) {
    Calendar from=Calendar.getInstance();
    from.setTime(c1.getTime());
    Calendar to=Calendar.getInstance();
    to.setTime(c2.getTime());

    if((from.get(Calendar.HOUR_OF_DAY) > 18)){
      from.add(Calendar.DATE, 1);
      from.set(Calendar.HOUR_OF_DAY,9);
      from.set(Calendar.MINUTE,0);
    }
    if((from.get(Calendar.HOUR_OF_DAY) < 9)){
      from.set(Calendar.HOUR_OF_DAY,9);
      from.set(Calendar.MINUTE,0);
    }
    if((to.get(Calendar.HOUR_OF_DAY) > 18)){
      to.set(Calendar.HOUR_OF_DAY,18);
      to.set(Calendar.MINUTE,0);
    }
    if((to.get(Calendar.HOUR_OF_DAY) < 9)){
      to.add(Calendar.DATE, -1);
      to.set(Calendar.HOUR_OF_DAY,18);
      to.set(Calendar.MINUTE,0);
    }
    while((from.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) || (from.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY)){
      from.add(Calendar.DATE, 1);
      from.set(Calendar.HOUR_OF_DAY,9);
      from.set(Calendar.MINUTE,0);
    }
    long diff = to.getTimeInMillis() - from.getTimeInMillis();
    while(from.before(to)){
      if(((from.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) || (from.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY))){
        diff-=24*60*60*1000;
      }
      from.add(Calendar.DATE, 1);
    }
    return diff;
  }


  public static String formatDate(String date, TimeZone timezone) {
    if (date == null) {
      return null;
    }

    Calendar today = Calendar.getInstance(timezone);
    Calendar cal = Calendar.getInstance(timezone);
    cal.setTime(new Date(Long.parseLong(date)));
    String format = "MMM dd yyyy";
    if (cal.get(Calendar.YEAR) == today.get(Calendar.YEAR)) {
      format = "MMM dd";
    }
    SimpleDateFormat df = new SimpleDateFormat(format);
    df.setTimeZone(timezone);
    return df.format(cal.getTime());
  }

  public static TimeZone getUserTimezone(String username) {
    try {
      CalendarService calService= CommonsUtils.getService(CalendarService.class);
      CalendarSetting setting = calService.getCalendarSetting(username);
      return TimeZone.getTimeZone(setting.getTimeZone());
    } catch (Exception e) {
      /*LOG.error("Can't retrieve timezone", e);*/
    }
    return null;
  }


}
