/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.api;


import org.exoplatform.ps.DTO.Category;
import org.exoplatform.ps.entity.CategoryEntity;


import java.util.List;

/**

 */
public interface BBCategoryStorage {

    public abstract CategoryEntity createBBCategory(String id, String catCsiDesc, String catAbrDesc, String catFullDesc, String groupIdn) throws Exception;

    public abstract void deleteBBCategory(String catId) throws Exception;

    public abstract void updateBBCategory(String catId, String label, String description) throws Exception;

    public abstract CategoryEntity getBBCategory(String catId) throws Exception;

    public abstract List<CategoryEntity> getBBCategories(int offset, int limit) throws Exception;

    public abstract CategoryEntity convert(Category category);
    public abstract Category convert(CategoryEntity category);
}
