/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.api;

import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.exoplatform.ps.entity.SubGroupEntity;

import java.util.List;

/**

 */
public interface SubCatGroupRelationStorage {

    public abstract SubCatGroupEntity createSubCatGroupRelation(String subGroupId, String subCatId, String subId, String subName, String catId, String catName, String groupName) throws Exception;

    public abstract void deleteSubCatGroupRelation(String id) throws Exception;

    public abstract List<SubCatGroupEntity> getRelationShipBySubCatId(String subCatId, int offset, int limit) throws Exception;

    public abstract List<SubCatGroupEntity> getRelationShipBySubGroupId(String subGroupId, int offset, int limit) throws Exception;

    public abstract List<SubCatGroupEntity> getRelationShipBySubId(String subId, int offset, int limit) throws Exception;

}
