/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.api;

import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.entity.SubContractorEntity;


import java.util.List;

/**

 */
public interface SubUserInfoStorage {

    public abstract SubContractorEntity createSubUserInfo(String userId, SubContractor userProfil) throws Exception;

    public abstract Boolean deleteSubUserInfo(String catId) throws Exception;

    public abstract SubContractorEntity updateSubUserInfo(String userId, SubContractor userProfil) throws Exception;

    public abstract SubContractorEntity getSubUserInfo(String userId) throws Exception;

    public abstract List<SubContractorEntity> getSubUserInfoByCompanyNameAndDisplayName(String displayName, String companyName, int offset, int limit) throws Exception;

    public abstract SubContractorEntity convert(SubContractor user);

    public abstract SubContractor convert(SubContractorEntity subContractorEntity);

}
