package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.DAO.CategoryDAO;
import org.exoplatform.ps.DTO.Category;
import org.exoplatform.ps.chromattic.entity.BBCategory;
import org.exoplatform.ps.chromattic.entity.CategoriesLocation;
import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.storage.api.BBCategoryStorage;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;

import javax.jcr.Node;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Medamine on 20/10/2014.
 */
public class BBCategoryStorageImpl extends AbstractStorage implements BBCategoryStorage {


    /**
     * Logger
     */
    private static final Log LOG = ExoLogger.getLogger(BBCategoryStorageImpl.class);
    private CategoryDAO categoryDAO;

    public BBCategoryStorageImpl(CategoryDAO categoryDAO) {
        this.categoryDAO=categoryDAO;
    }

    @Override
    public CategoryEntity createBBCategory(String catId, String catCsiDesc, String catAbrDesc, String catFullDesc, String groupIdn) throws Exception {
        CategoryEntity categoryEntity = new CategoryEntity();
        categoryEntity.setId(catId);
        categoryEntity.setCatCsiDesc(catCsiDesc);
        categoryEntity.setCatAbrDesc(catAbrDesc);
        categoryEntity.setCatFullDesc(catFullDesc);
        return categoryDAO.create(categoryEntity);
    }

    @Override
    public void deleteBBCategory(String catId) throws Exception {
        CategoryEntity categoryEntity = categoryDAO.find(catId);
        categoryDAO.delete(categoryEntity);
    }

    @Override
    public void updateBBCategory(String catId, String label, String description) throws Exception {

    }

    @Override
    public CategoryEntity getBBCategory(String catId) throws Exception {
        return categoryDAO.find(catId);
    }

    @Override
    public List<CategoryEntity> getBBCategories(int offset, int limit) throws Exception {
        return categoryDAO.getAll(offset,limit);
    }

    @Override
    public CategoryEntity convert(Category category) {
        CategoryEntity categoryEntity=new CategoryEntity();
        categoryEntity.setId(category.getId());
        categoryEntity.setCatAbrDesc(category.getCatAbrDesc());
        categoryEntity.setCatFullDesc(category.getCatFullDesc());
        categoryEntity.setCatCsiDesc(category.getCatCsiDesc());
        return categoryEntity;
    }

    @Override
    public Category convert(CategoryEntity categoryEntity) {
        Category category=new Category();
        category.setId(categoryEntity.getId());
        category.setCatAbrDesc(categoryEntity.getId()+"-"+categoryEntity.getCatAbrDesc());
        category.setCatFullDesc(categoryEntity.getId()+"-"+categoryEntity.getCatFullDesc());
        category.setCatCsiDesc(categoryEntity.getId()+"-"+categoryEntity.getCatCsiDesc());
        return category;
    }
}
