package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.chromattic.entity.CustomFields;
import org.exoplatform.ps.chromattic.entity.Field;
import org.exoplatform.ps.storage.api.CustomFieldsStorage;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;

import javax.jcr.Node;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Medamine on 19/06/2014.
 */
public class CustomFieldsStorageImpl extends AbstractStorage implements CustomFieldsStorage {

    /**
     * Logger
     */
    private static final Log LOG = ExoLogger.getLogger(CustomFieldsStorageImpl.class);
    private static final String CHROMATTIC_LIFECYCLE_NAME = "tbb";
    private ChromatticLifeCycle lifeCycle;

    public CustomFieldsStorageImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle("tbb");
    }

    public ChromatticSession getSession() {
        return lifeCycle.getChromattic().openSession();
    }

    @Override
    public void createField(String fieldName, String label, String type, String value, boolean required) throws Exception {
        Node node = getSession().getJCRSession().getRootNode();
        node = node.getNode("production");
        if (!node.hasNode("customfields")) {
            node = node.addNode("customfields", "tbb:customFields");
            node.addMixin("mix:referenceable");
            node.getSession().save();
        } else {
            node = node.getNode("customfields");
        }
        CustomFields parentNode = (CustomFields) getSession().findByPath(CustomFields.class, node.getPath(), true);
        Field field = (Field) getSession().create(Field.class, fieldName);
        getSession().persist(parentNode, field);
        getSession().save();
        field.setFieldName(fieldName);
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        field.setRequired(required);
        getSession().save();
    }

    @Override
    public void deleteField(String fieldName) throws Exception {
        ChromatticSession session = getSession();
        try {
            Field field = (Field) session.findByPath(Field.class, "/production/customfields/" + fieldName, true);
            if (field != null) {
                session.remove(field);
                session.save();
            } else {
                LOG.error("Node to delete not found");
            }
        } finally {
            session.close();
        }
    }

    @Override
    public void deleteCustomField() throws Exception {
        ChromatticSession session = getSession();
        try {
            CustomFields customField = (CustomFields) session.findByPath(CustomFields.class, "/production/customfields", true);
            if (customField != null) {
                session.remove(customField);
                session.save();
            } else {
                LOG.error("Node to delete not found");
            }
        } finally {
            session.close();
        }
    }

    @Override
    public List<Field> getFields() throws Exception {
        QueryBuilder<Field> builder = getSession().createQueryBuilder(Field.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, "/production/customfields" + StorageUtils.SLASH_STR + StorageUtils.PERCENT_STR);
        builder.where(whereExpression.toString());
        org.chromattic.core.query.QueryImpl<Field> queryImpl = (org.chromattic.core.query.QueryImpl) builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl) queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult<Field> results = queryImpl.objects();
        List<Field> sResult = new ArrayList();
        while (results.hasNext()) {
            Field field = (Field) results.next();
            sResult.add(field);
        }
        return sResult;
    }
}
