/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.impl;


import org.exoplatform.ps.DAO.ProjectSubDAO;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.ProjectSubListAccess;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.QueryFunction;
import org.exoplatform.social.core.storage.query.WhereExpression;

import javax.jcr.Node;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**

 */
public class ProjectSubRelationShipStorageImpl extends AbstractStorage implements ProjectSubRelationShipStorage {

    private static final Log LOG = ExoLogger.getLogger(ProjectSubRelationShipStorageImpl.class);
    private ProjectSubDAO projectSubDAO;

    public ProjectSubRelationShipStorageImpl(ProjectSubDAO projectSubDAO) {
        this.projectSubDAO = projectSubDAO;
    }



    @Override
    public ProjectSubEntity createProjectSubRelationShip(SubCatEntity subCat, String projectId, String status, String note, String relrank, String bidScoped) throws Exception {
/*       ProjectSubEntity rel = projectSubDAO.find()

        if (rel != null) {*/
            ProjectSubEntity rel = new ProjectSubEntity();

            String SubCatProjectID= subCat.getSubContractor().getId()+ "_" + projectId + "_" + subCat.getCategory().getId();
            rel.setId(SubCatProjectID);
            rel.setSubContractor(subCat.getSubContractor());
            rel.setCategory(subCat.getCategory());
            rel.setStatus(status);
            rel.setProjectId(projectId);
            rel.setNote(note);
            rel.getSubContractor().setRank(relrank);
            rel.setBidScoped(bidScoped);

            projectSubDAO.create(rel);
            return rel;
  /*      }
        return rel;*/
    }

    @Override
    public void deleteProjectSubRelationShip(String SubCatProjectID) throws Exception {
        ProjectSubEntity rel = new ProjectSubEntity();
        try {

            if (rel != null) {
        ProjectSubEntity projectSubEntity = projectSubDAO.find(SubCatProjectID);
        projectSubDAO.delete(projectSubEntity);
        } else {
            LOG.error("delete not found");
        }
    } finally {
        //session.close();
    }
    }

    @Override
    public ProjectSubEntity updateProjectSubRelationShip(String SubCatProjectID, SubCatEntity subCat, String status, String note, String bid, String relrank, String bidScoped) throws Exception {
        ProjectSubEntity relation = new ProjectSubEntity();
        try {

            if (relation != null) {

                if (status != null && !status.equals("")) relation.setStatus(status);
                if (note != null && !note.equals("")) relation.setNote(note);
                if (bid != null) relation.setBid(bid);
                if (relrank != null) relation.getSubContractor().setRank(relrank);
                if (bidScoped != null) relation.setBidScoped(bidScoped);
                if (subCat != null) {
                    relation.getSubContractor().setDisplayName(subCat.getSubContractor().getDisplayName());
                    relation.getSubContractor().setCompany(subCat.getSubContractor().getCompany());
                    relation.getSubContractor().setPhone(subCat.getSubContractor().getPhone());
                    relation.getSubContractor().setCity(subCat.getSubContractor().getCity());
                    relation.getSubContractor().setCountry(subCat.getSubContractor().getCountry());
                    relation.getSubContractor().setState(subCat.getSubContractor().getState());
                    relation.getSubContractor().setUnion(subCat.getSubContractor().getUnion());
                    relation.getSubContractor().setNonUnion(subCat.getSubContractor().getNonUnion());

                    relation = projectSubDAO.update(relation) ;
            } else {
                LOG.error("Node to update not found");
            }
        }} finally {
            // session.close();
        }
        return relation;
    }

    @Override
    public List<ProjectSubEntity> getRelationShipBySubId(String subId, int offset, int limit) throws Exception {
        return  projectSubDAO.getRelationShipBySubId(subId,offset,limit);
    }

    @Override
    public List<ProjectSubEntity> getRelationShipBySubIdAndCatId(String subId, String catId, int offset, int limit) throws Exception {
        return projectSubDAO.getRelationShipBySubCat(subId, catId,offset,limit);
    }

    @Override
    public List<ProjectSubEntity> getRelationShipByProjectId(String projectId, int offset, int limit) throws Exception {
        return projectSubDAO.getRelationShipByProjectId(projectId,offset,limit);
    }



    @Override
    public List<ProjectSubEntity> getRelationShipByProjectIdAndStatus(String projectId, String status, int offset, int limit) throws Exception {
        return projectSubDAO.getRelationShipByProjectIdAndStatus(projectId,status,offset,limit);
    }


    @Override
    public List<ProjectSubEntity> getRelationShipByProjectIdAndSearchConditions(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String sortBy, String sortDir, String projectId, long offset, long limit) throws Exception {
        return null;
    }

    @Override
    public int getRelationShipCountByProjectIdAndStatus(String projectId, String status) throws Exception {
        return projectSubDAO.getRelationShipCountByProjectIdAndStatus(projectId,status);
    }

    @Override
    public List<ProjectSubEntity> getRelationShipByProjectIdAndCatId(String projectId, String catId, int offset, int limit) throws Exception {
        return projectSubDAO.getRelationShipByProjectIdAndCatId(projectId,catId,offset,limit);
    }

    @Override
    public List<ProjectSubEntity> getRelationShipBySubIdAndStatus(String subId, String status, int offset, int limit) throws Exception {
        return projectSubDAO.getRelationShipBySubIdAndStatus(subId,status,offset,limit);
    }

    @Override
    public List<ProjectSubEntity> getRelationShipByProjectIdAndSubId(String projectId, String subId, int offset, int limit) throws Exception {
        return  projectSubDAO.getRelationShipByProjectIdAndSubId(projectId,subId,offset,limit);
    }

    @Override
    public int getRelationShipCountByProjectIdAndSubId(String projectId, String subId) throws Exception {
        return projectSubDAO.getRelationShipCountByProjectIdAndSubId(projectId,subId);
    }

    @Override
    public int getRelationShipCountByProjectIdAndCatId(String projectId, String catId) throws Exception {
        return projectSubDAO.getRelationShipCountByProjectIdAndCatId(projectId,catId);
    }

    @Override
    public int getRelationShipCountBySubIdAndStatus(String subId, String status) throws Exception {
        return projectSubDAO.getRelationShipCountBySubIdAndStatus(subId,status);
    }

    @Override
    public ProjectSubEntity getRelationShip(String subId, String projectId, String catId) throws Exception {
        ProjectSubEntity projectSubEntity = projectSubDAO.find(subId+ "_" + projectId + "_" + catId);
        return projectSubEntity;
    }

    @Override
    public ProjectSubEntity getRelationShip(String SubCatProjectID) throws Exception {

        ProjectSubEntity projectSubEntity = projectSubDAO.find(SubCatProjectID);
        return projectSubEntity;
    }

    @Override
    public int getRelationShipsCountbyProjectIdCatIdAndstatus(String projectId, String catId, String status) throws Exception {
        return projectSubDAO.getRelationShipsCountbyProjectIdCatIdAndstatus(projectId,catId,status);
    }

    @Override
    public int getRelationShipCountBySubId(String subId) throws Exception {
        return projectSubDAO.getRelationShipCountBySubId(subId);
    }

    @Override
    public int getRelationShipCountByProjectId(String projectId) throws Exception {
        return projectSubDAO.getRelationShipCountByProjectId(projectId);
    }

    @Override
    public int getRelationShipCountByProjectIdAndSearchConditions(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String projectId) throws Exception {
        return projectSubDAO.getRelationShipCountByProjectIdAndSearchConditions(isInvitedTable,isVendor,isMessaged,searchCondition,SearchConditions,include, projectId);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipBySubIdListAccess(String subId) throws Exception {
        return new ProjectSubListAccess(subId, ProjectSubListAccess.Type.SUBID);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipByProjectIdListAccess(String projectId) throws Exception {
        return new ProjectSubListAccess(projectId, ProjectSubListAccess.Type.PROJECTID);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndSearchCondListAccess(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String sortBy, String sortDir, String projectId) throws Exception {
        return new ProjectSubListAccess(projectId, ProjectSubListAccess.Type.PROJECTID);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndCatIdListAccess(String projectId, String catId) throws Exception {
        return new ProjectSubListAccess(projectId, catId, ProjectSubListAccess.Type.PROJECTID_CATID);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndStatusListAccess(String projectId, String status) throws Exception {
        return new ProjectSubListAccess(projectId, status, ProjectSubListAccess.Type.PROJECTID_STATUS);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndSubIdListAccess(String projectId, String subId) throws Exception {
        return new ProjectSubListAccess(projectId, subId, ProjectSubListAccess.Type.PROJECTID_SUBID);
    }

    @Override
    public ListAccess<ProjectSubEntity> getRelationShipBySubIdAndStatusListAccess(String subId, String status) throws Exception {
        return new ProjectSubListAccess(subId, status, ProjectSubListAccess.Type.SUBID_STATUS);
    }
}