/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.DAO.SubCatGroupDAO;

import org.exoplatform.ps.entity.SubCatGroupEntity;

import org.exoplatform.ps.storage.api.SubCatGroupRelationStorage;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.WhereExpression;
import java.util.ArrayList;
import java.util.List;

/**

 */
public class SubCatGroupRelationStorageImpl extends AbstractStorage implements SubCatGroupRelationStorage {
    private static final Log LOG = ExoLogger.getLogger(SubCatGroupRelationStorageImpl.class);
    private SubCatGroupDAO subCatGroupDAO;

    public SubCatGroupRelationStorageImpl(SubCatGroupDAO subCatGroupDAO) {
        this.subCatGroupDAO = subCatGroupDAO;
    }

    @Override
    public SubCatGroupEntity createSubCatGroupRelation(String subGroupId, String subCatId, String subId, String subName, String catId, String catName, String groupName) throws Exception {
        SubCatGroupEntity rel = new SubCatGroupEntity();

            subCatId=subId + "_" + catId;
            rel.getSubCat().setId(subCatId);
            rel.setId(subGroupId + "_" + subCatId);
            rel.getSubGroup().setId(subGroupId);
            rel.getCategory().setId(catId);
            rel.getSubContractor().setId(subId);
            rel.getSubContractor().setDisplayName(subName);
            rel.getCategory().setFieldName(catName);
            rel.getSubGroup().setSubGroupName(groupName);


        return subCatGroupDAO.create(rel);
    }

    @Override
    public void deleteSubCatGroupRelation(String id) throws Exception {
        SubCatGroupEntity subCatGroupEntity = subCatGroupDAO.find(id);
        subCatGroupDAO.delete(subCatGroupEntity);
    }

    @Override
    public List<SubCatGroupEntity> getRelationShipBySubCatId(String subCatId, int offset, int limit) throws Exception {
        return subCatGroupDAO.getRelationShipBySubCatId(subCatId,offset,limit);
    }

    @Override
    public List<SubCatGroupEntity> getRelationShipBySubGroupId(String subGroupId, int offset, int limit) throws Exception {
        return subCatGroupDAO.getRelationShipBySubGroupId(subGroupId,offset,limit);
    }

    @Override
    public List<SubCatGroupEntity> getRelationShipBySubId(String subId, int offset, int limit) throws Exception {
        return subCatGroupDAO.getRelationShipBySubId(subId,offset,limit);
    }
}