package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.DAO.SubCatDAO;
import org.exoplatform.ps.chromattic.entity.SubCat;
import org.exoplatform.ps.chromattic.entity.SubCatLocation;
import org.exoplatform.ps.chromattic.entity.SubUserInfo;
import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubCatStorage;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.QueryFunction;
import org.exoplatform.social.core.storage.query.WhereExpression;

import javax.jcr.Node;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Medamine on 20/10/2014.
 */
public class SubCatStorageImpl extends AbstractStorage implements SubCatStorage {
    private static final Log LOG = ExoLogger.getLogger(SubCatStorageImpl.class);
    private SubCatDAO subCatDAO = new SubCatDAO();

    public SubCatStorageImpl(SubCatDAO subCatDAO) {
        this.subCatDAO = subCatDAO;
    }

    @Override
    public SubCatEntity createSubCat(String subId, String catId, SubContractorEntity userProfile, String subRank, String catAbrDesc, String catFullDesc, String catCsiDesc) throws Exception {
        SubCatEntity subCatEntity = new SubCatEntity();
      CategoryEntity cat = new CategoryEntity();
      SubContractorEntity sub = new SubContractorEntity();
       String subcatId =sub.getId() + "_" + cat.getId();
        subCatEntity.setId(subcatId);
        subCatEntity.setCategory(cat);
        subCatEntity.setSubContractor(sub);
        subCatEntity.getSubContractor().setRank(subRank);
        return subCatDAO.create(subCatEntity);
    }

    @Override
    public SubCatEntity createSubCat(String subcatId, CategoryEntity cat, SubContractorEntity sub, String subRank) throws Exception {
        SubCatEntity subCatEntity = new SubCatEntity();

            new SubCatEntity();
            subcatId=sub.getId() + "_" + cat.getId();
            if(subCatDAO.find(subcatId)==null){
                subCatEntity.setId(subcatId);
                subCatEntity.setCategory(cat);
                subCatEntity.setSubContractor(sub);
                subCatEntity.getSubContractor().setRank(subRank);
                return subCatDAO.create(subCatEntity);
            }
        return null;
    }


    @Override
    public void deleteSubCat(String id) throws Exception {
        SubCatEntity subCatEntity  = subCatDAO.find(id);
        subCatDAO.delete(subCatEntity);
    }

    @Override
    public void updateSubCat(String subCatName, SubContractorEntity userProfile, String subRank) throws Exception {

        try {
            SubCatEntity subCatEntity = new SubCatEntity();
            if (subCatEntity != null) {
                if (subRank != null)  subCatEntity.getSubContractor().setRank(subRank);
                if (userProfile != null) {
                    subCatDAO.update(subCatEntity) ;
                }
            }
        } finally {

        }

    }

    @Override
    public SubCatEntity getSubCat(String id) throws Exception {

        SubCatEntity subCatEntity = subCatDAO.find(id);

        return subCatEntity;

    }

    @Override
    public List<SubCatEntity> getSubCatsBySubId(String subId, int offset, int limit) throws Exception {
        return subCatDAO.getSubCatBySubId(subId,offset,limit);
    }

    @Override
    public List<SubCatEntity> getSubCatsByCatId(String catId, int offset, int limit) throws Exception {
        return subCatDAO.getSubCatByCatId(catId,offset,limit);
    }

    @Override
    public List<SubCatEntity> subCatSearch(boolean isVendor, String searchCondition, List<String> SearchConditions, List<SubCatEntity> excluded, List<SubCatEntity> include, String orderBy, String order, long offset, long limit) throws Exception {
        return subCatDAO.findAll();
    }

    @Override
    public int subCatSearchCount(boolean isVendor, String searchCondition, List<String> SearchConditions, List<SubCatEntity> excluded, List<SubCatEntity> include) throws Exception {
        return subCatDAO.subCatSearchCount();
    }
}
