package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.DAO.SubGroupDAO;
import org.exoplatform.ps.chromattic.entity.SubGroup;
import org.exoplatform.ps.chromattic.entity.SubGroupLocation;
import org.exoplatform.ps.entity.SubGroupEntity;
import org.exoplatform.ps.storage.api.SubGroupStorage;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;

import javax.jcr.Node;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Medamine on 20/10/2014.
 */
public class SubGroupStorageImpl extends AbstractStorage implements SubGroupStorage {

    private static final Log LOG = ExoLogger.getLogger(SubGroupStorageImpl.class);
    private SubGroupDAO subGroupDAO;

    public SubGroupStorageImpl(SubGroupDAO subGroupDAO) {
        this.subGroupDAO = subGroupDAO;}



    @Override
    public SubGroupEntity createSubGroup(String SubGroupId, String subGroupName) throws Exception {
        SubGroupEntity subGroupEntity = new SubGroupEntity();
            subGroupEntity.setId(SubGroupId);
            subGroupEntity.setSubGroupName(subGroupName);

        return subGroupDAO.create(subGroupEntity);
    }

    @Override
    public void deleteSubGroup(String SubGroupId) throws Exception {
          SubGroupEntity subGroupEntity = subGroupDAO.find(SubGroupId);
        subGroupDAO.delete(subGroupEntity);
    }

    @Override
    public void updateSubGroup(String SubGroupId, String subGroupName) throws Exception {
        try {
            SubGroupEntity subGroupEntity = new SubGroupEntity();
            if (subGroupEntity != null) {
                if ( subGroupName!= null)  subGroupEntity.setSubGroupName(subGroupName);

                if (subGroupEntity != null) {
                    subGroupDAO.update(subGroupEntity) ;
                }
            }
        } finally {

        }
    }

    @Override
    public SubGroupEntity getSubGroup(String SubGroupId) throws Exception {
        SubGroupEntity subGroupEntity = subGroupDAO.find(SubGroupId);
        return subGroupEntity;
    }

    @Override
    public List<SubGroupEntity> getSubGroups(int offset, int limit) throws Exception {
        return subGroupDAO.getAll(offset,limit);
    }
}
