package org.exoplatform.ps.utils;

import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.picocontainer.Startable;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import java.io.InputStream;

/**
 * Created by Medamine on 03/04/2015.
 */
public class UpgradeService implements Startable {
    private static final Log LOG = ExoLogger.getLogger(UpgradeService.class.getName());

    @Override
    public void start() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager) portalContainer.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle) manager.getLifeCycle(SocialChromatticLifeCycle.SOCIAL_LIFECYCLE_NAME);
        RepositoryService repositoryService = (RepositoryService) portalContainer.getComponentInstanceOfType(RepositoryService.class);
        Session session = null;
        try {
            ManageableRepository repository = repositoryService.getCurrentRepository();
            SessionProviderService sessionProviderService = (SessionProviderService) portalContainer.getComponentInstanceOfType(SessionProviderService.class);
            SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
            session = sProvider.getSession(lifeCycle.getWorkspaceName(), repository);
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager) session.getWorkspace().getNodeTypeManager();
            try {

                NodeType nodeType = nodeTypeManager.findNodeType(InternalQName.parse("[http://www.exoplatform.org/jcr/tbb/1.0/]projectSubRelationShip"));
                Boolean exist = false;
                for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                    if (propertyDefinition.getName().equals("tbb:bidScoped")) {
                        exist = true;
                        break;
                    }
                }
                if (!exist) {
                    LOG.info("Update BBN nodeTypes");
                    nodeTypeManager.registerNodeTypes(getModelIS(), ExtendedNodeTypeManager.REPLACE_IF_EXISTS, "text/xml");
                    session.save();
                }
            } catch (IllegalNameException e) {
                LOG.error(e.getMessage(), e);
            }


        } catch (RepositoryException e) {
            LOG.error(e);
        } finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }


    }

    @Override
    public void stop() {

    }


    public InputStream getModelIS() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/portal/tbb-chromattic-nodetypes.xml");
    }

}
