package org.exoplatform.ps.utils;


import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubStaffCompanyDAO;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubStaffCompanyEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.NodetypeConstant;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
//import org.exoplatform.social.plugin.doc.UIBBNDocActivity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.webui.cssfile.CssClassUtils;

import javax.jcr.Node;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;


import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;


/**
 * Created by Medamine on 25/09/2014.
 */
public class Utils {

    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "collaboration";
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String UPLOAD_FOLDER_NODE_URI = "uploadFolderNodeUri";
    private static final String UPLOAD_FOLDER_NODE_NAME = "uploadFolderNodeName";
    private static final String FILE_SPACES = "files:spaces";
    private final static String POPUP_COMPOSER = "UIPopupComposer";
    //private final static String docActivityTitle = "<a href=\"${" + UIBBNDocActivity.DOCLINK + "}\">" + "${" + UIBBNDocActivity.DOCNAME + "}</a>";
    private static final String SUBS_GROUP = "/organization/subcontractors";
    private static OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    private static SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
    private static IdentityManager identityManager = (IdentityManager) PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
    private static ActivityManager activityManager = (ActivityManager) PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
    private static RepositoryService repositoryService = (RepositoryService) PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
    private static String documentRefLink;
    private static String documentPath;
    private static String documentName;
    private static boolean isDocumentReady;
    private static String currentUser;
    private static String docIcon = "";
    private static final Log LOG = ExoLogger.getLogger(Utils.class.getName());

    private static final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);


    public static String getMd5(String checksum) throws NoSuchAlgorithmException {

        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(checksum.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString((array[i] & 0xFF) | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static Date getTime() throws IOException {

      /*  String TIME_SERVER = "3.north-america.pool.ntp.org";
        NTPUDPClient timeClient = new NTPUDPClient();
        int timeoutTime = 120000;//We want to timeout if a response takes longer than 2 min to get time from server
        timeClient.setDefaultTimeout(timeoutTime);
        InetAddress inetAddress = InetAddress.getByName(TIME_SERVER);
        TimeInfo timeInfo = timeClient.getTime(inetAddress);
        long returnTime = timeInfo.getReturnTime();
        Date time = new Date(returnTime);*/
        DateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
        formatter1.setTimeZone(TimeZone.getTimeZone("GMT+1"));
        formatter1.format(Calendar.getInstance().getTime());
        Date time1 =formatter1.getCalendar().getTime();
        LOG.info("Date  "+formatter1.getCalendar().get(Calendar.MONTH)+" _ "+formatter1.getCalendar().get(Calendar.DAY_OF_MONTH)+" _ "+formatter1.getCalendar().get(Calendar.HOUR));
        return time1;
    }

    private static boolean isGCMember(String userName) throws Exception {
        Collection<Group> groupsList = orgService.getGroupHandler().findGroupsOfUser(userName);
        for (Group group : groupsList) {
            if (group.getId().equals(GCS_GROUP)) {
                return true;
            }
        }
        return false;
    }

    public static String getCompanyName(String receiver) throws Exception {
        if (isGCMember(receiver))
            return "(Internal Employees)";
        SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(receiver);
        if (userInfo != null && userInfo.getCompany() != null) {
            return "(" + userInfo.getCompany() + ")";

        }
        return "";
    }

    public static void createBBNDocActivity(Node currentNode, String receiver) {
        try {
/*            String rawPath = currentNode.getPath();
            rawPath = rawPath.substring(rawPath.indexOf(":/") + 2);
            documentRefLink = buildDocumentLink(rawPath);
            documentName = rawPath.substring(rawPath.lastIndexOf("/") + 1);
            documentPath = buildDocumentPath(rawPath);
            isDocumentReady = true;
            documentRefLink = documentRefLink.replace("//", "/");
            documentPath = documentPath.replace("//", "/");
            docIcon = CssClassUtils.getCSSClassByFileNameAndFileType(documentName, "", null);
            String space = rawPath.split("/spaces/")[1].split("/")[0];
            Map<String, String> activityParams = new LinkedHashMap<String, String>();
            activityParams.put(UIBBNDocActivity.DOCNAME, documentName);
            activityParams.put(UIBBNDocActivity.DOCLINK, documentRefLink);
            activityParams.put(UIBBNDocActivity.DOCPATH, documentPath);
            activityParams.put(UIBBNDocActivity.REPOSITORY, REPOSITORY);
            activityParams.put(UIBBNDocActivity.WORKSPACE, WORKSPACE);
            activityParams.put(UIBBNDocActivity.MESSAGE,documentName+ " has been uploaded into ");
            activityParams.put(UPLOAD_FOLDER_NODE_URI, "/g/:spaces:" + space + "/" + space + "/documents?path=" + space + "/Groups/spaces/" + rawPath.substring(0, rawPath.lastIndexOf("/")).split("/spaces/")[1]);
            activityParams.put(UPLOAD_FOLDER_NODE_NAME, documentPath.split("/")[documentPath.split("/").length-2]);
            activityParams.put(BaseActivityProcessorPlugin.TEMPLATE_PARAM_TO_PROCESS, UIBBNDocActivity.MESSAGE);
            activityParams.put("receiver", receiver);
            if (currentNode.getPrimaryNodeType().getName().equals(NodetypeConstant.NT_FILE)) {
                String activityOwnerId = UIBBNDocActivity.getActivityOwnerId(currentNode);
                DateFormat dateFormatter = null;
                dateFormatter = new SimpleDateFormat(ISO8601.SIMPLE_DATETIME_FORMAT);

                String illustrationImg = UIBBNDocActivity.getIllustrativeImage(currentNode);
                String strDateCreated = "";
                if (currentNode.hasProperty(NodetypeConstant.EXO_DATE_CREATED)) {
                    Calendar dateCreated = currentNode.getProperty(NodetypeConstant.EXO_DATE_CREATED).getDate();
                    strDateCreated = dateFormatter.format(dateCreated.getTime());
                }
                String strLastModified = "";
                if (currentNode.hasNode(NodetypeConstant.JCR_CONTENT)) {
                    Node contentNode = currentNode.getNode(NodetypeConstant.JCR_CONTENT);
                    if (contentNode.hasProperty(NodetypeConstant.JCR_LAST_MODIFIED)) {
                        Calendar lastModified = contentNode.getProperty(NodetypeConstant.JCR_LAST_MODIFIED)
                                .getDate();
                        strLastModified = dateFormatter.format(lastModified.getTime());
                    }
                }

                activityParams.put(UIBBNDocActivity.ID, currentNode.isNodeType(NodetypeConstant.MIX_REFERENCEABLE) ? currentNode.getUUID() : "");
                activityParams.put(UIBBNDocActivity.CONTENT_NAME, currentNode.getName());
                activityParams.put(UIBBNDocActivity.AUTHOR, activityOwnerId);
                activityParams.put(UIBBNDocActivity.DATE_CREATED, strDateCreated);
                activityParams.put(UIBBNDocActivity.LAST_MODIFIED, strLastModified);
                activityParams.put(UIBBNDocActivity.CONTENT_LINK, UIBBNDocActivity.getContentLink(currentNode));
                activityParams.put(UIBBNDocActivity.ID, currentNode.isNodeType(NodetypeConstant.MIX_REFERENCEABLE) ? currentNode.getUUID() : "");
                activityParams.put(UIBBNDocActivity.MIME_TYPE, UIBBNDocActivity.getMimeType(currentNode));
                activityParams.put(UIBBNDocActivity.IMAGE_PATH, illustrationImg);
            }
            postActivityToSpace(rawPath, activityParams);*/
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }


    public static void postActivityToSpace(String path, Map<String, String> activityParams) throws Exception {
        String space = path.split("/spaces/")[1].split("/")[0];
        Identity spaceIdentity = identityManager.getOrCreateIdentity(SpaceIdentityProvider.NAME, space, false);
        String remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
        ExoSocialActivity activity = saveActivity(activityParams, activityManager, identityManager, spaceIdentity, remoteUser);

    }

    public static ExoSocialActivity saveActivity(Map<String, String> activityParams, ActivityManager activityManager, IdentityManager identityManager, Identity ownerIdentity, String remoteUser) throws Exception {
/*        Node node = getDocNode(activityParams.get(UIBBNDocActivity.REPOSITORY), activityParams.get(UIBBNDocActivity.WORKSPACE),
                activityParams.get(UIBBNDocActivity.DOCPATH));
        String activity_type = UIBBNDocActivity.ACTIVITY_TYPE;
        Identity userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, remoteUser, true);
        String title = activityParams.get(UIBBNDocActivity.MESSAGE);
        if (title == null || title.length() == 0) {
            title = docActivityTitle;
        }
        ExoSocialActivity activity = new ExoSocialActivityImpl(userIdentity.getId(), activity_type, title, null);
        activity.setTemplateParams(activityParams);
        activityManager.saveActivityNoReturn(ownerIdentity, activity);
        String activityId = activity.getId();
        if (isSubMember(remoteUser) == isSubMember(node.getProperty("exo:owner").getString())) {
            if (!StringUtils.isEmpty(activityId)) {
                ActivityTypeUtils.attachActivityId(node, activityId);
            //    node.save();
            }
        }
        return activityManager.getActivity(activity.getId());*/
return null;
    }

    public static Node getDocNode(String repository, String workspace, String docPath) {
        NodeLocation nodeLocation = new NodeLocation(repository, workspace, docPath);
        return NodeLocation.getNodeByLocation(nodeLocation);
    }

    public static String buildDocumentLink(String rawPath) {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        String restService = "jcr";
        return new StringBuilder().append("/").append(portalContainerName)
                .append("/").append(restContextName)
                .append("/").append(restService)
                .append("/").append(REPOSITORY)
                .append("/").append(WORKSPACE)
                .append("/").append(rawPath).toString();
    }

    private static boolean isSubMember(String userName) throws Exception {
        OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        Collection<Group> groupsList = orgService.getGroupHandler().findGroupsOfUser(userName);
        for (Group group : groupsList) {
            if (group.getId().equals(SUBS_GROUP)) {
                return true;
            }
        }
        return false;
    }

    public static String buildDocumentPath(String rawPath) {
        return "/" + rawPath;
    }



    public static boolean addToSpace(Space project,String userName){

        String currentTenant =ConversationState.getCurrent().getAttribute("currentTenant") == null ? "local" :  ConversationState.getCurrent().getAttribute("currentTenant").toString();
        LOG.info("SubContractor is about to be added to "+project.getDisplayName()+" project in tenant "+ currentTenant);
        Lock lock = getLock(project,currentTenant);
        lock.lock();
        try {
            String portalContainerName = "portal";
            Util.getIdentityManager(portalContainerName).getOrCreateIdentity(OrganizationIdentityProvider.NAME, userName, true);
            Util.getSpaceService(portalContainerName).addMember(project, userName);
            LOG.info("SubContractor has been added to "+project.getDisplayName()+" project in tenant "+ currentTenant);
            return true;
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        finally
        {
            lock.unlock();
        }
        return false;
    }


    private static Lock getLock(Space project, String tenantName)
    {
        String key = tenantName+"_"+project.getPrettyName();

        Lock lock = locks.get(key);
        if (lock != null)
        {
            return lock;
        }
        lock = new InternalLock(key);
        Lock prevLock = locks.putIfAbsent(key, lock);
        if (prevLock != null)
        {
            lock = prevLock;
        }
        return lock;

    }



    /**
     * This kind of locks can self unregister from the map of locks
     */
    private static class InternalLock extends ReentrantLock {

        /**
         * Serial Version UID
         */
        private static final long serialVersionUID = -3362387346368015145L;

        /**
         * The id corresponding to the lock in the map
         */
        private final String fullPath;

        /**
         * The default constructor
         * @param fullId the id corresponding to the lock in the map
         */
        public InternalLock(String fullPath) {
            super();
            this.fullPath = fullPath;
        }

        @Override
        public void unlock() {
            if (!hasQueuedThreads()) {
                // No thread is currently waiting for this lock
                // The lock will then be removed
                locks.remove(fullPath, this);
            }
            super.unlock();
        }
    }


    public static InputStream getAvatarInputStream(Long avatarId) throws IOException {
        FileItem file = null;
        if (avatarId == null) {
            return null;
        }
        try {
            file = CommonsUtils.getService(FileService.class).getFile(avatarId);
        } catch (FileStorageException e) {
            return null;
        }

        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    public static String getCurrentCompanyName(){
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        StaffDAO staffDAO = CommonsUtils.getService(StaffDAO.class);
        SubStaffCompanyDAO subStaffCompanyDAO = CommonsUtils.getService(SubStaffCompanyDAO.class);

        StaffEntity staffEntity = staffDAO.find(userId);
        if(staffEntity!=null){
            return staffEntity.getGeneralContractorEntity().getCompanyName();
        }

        SubStaffCompanyEntity subStaffCompanyEntity = subStaffCompanyDAO.find(userId);
        if (subStaffCompanyEntity != null){
            return  subStaffCompanyEntity.getSubContractorEntity().getCompany();
        }

        return "";
    }



}
