/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.integration.notification;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.service.rest.Util;

public class PSCreateProjectPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(PSCreateProjectPlugin.class);
    public static final String ID = "PSCreateProjectPlugin";
    public static final ArgumentLiteral<Space> PROJECT = new ArgumentLiteral(Space.class, "PROJECT");
    public static final ArgumentLiteral<String> CREATOR = new ArgumentLiteral(String.class, "creator");
    public static final ArgumentLiteral<Set> RECEIVERS = new ArgumentLiteral(Set.class, "receivers");
    IdentityManager identityManager;

    public PSCreateProjectPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        HashSet receivers = new HashSet();
        String creator = (String)ctx.value(CREATOR);
        String portalContainerName = "portal";
        Space space = (Space)ctx.value(PROJECT);
        Identity prIdentity = Util.getIdentityManager((String)"portal").getOrCreateIdentity("space", space.getPrettyName(), true);
        String IdGc = String.valueOf(prIdentity.getProfile().getProperty("gc"));
        long gcId = Long.parseLong(IdGc);
        return NotificationInfo.instance().setFrom("Create Project").to(new LinkedList((Collection)ctx.value(RECEIVERS))).with("creator", creator).with("projectname", space.getDisplayName()).with("project_descr", space.getDescription()).with("ProjectUrl", space.getUrl()).with("url", CommonsUtils.getCurrentDomain() + "/portal/g/:spaces:" + space.getUrl() + "/" + space.getUrl() + "/projectSettings").key(this.getKey()).end();
    }
}

