/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.DAO.CompanySubDAO;
import org.exoplatform.ps.entity.SubCompanyEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubCompanyStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;

public class SubCompanyStorageImpl
extends AbstractStorage
implements SubCompanyStorage {
    private static final Log LOG = ExoLogger.getLogger(SubCompanyStorageImpl.class);
    private CompanySubDAO companySubDAO = new CompanySubDAO();

    public SubCompanyStorageImpl(CompanySubDAO subCatDAO) {
        this.companySubDAO = subCatDAO;
    }

    @Override
    public SubCompanyEntity createSubCompany(Long id, SubContractorEntity subContractorEntity, String firstName, String lastName) throws Exception {
        SubCompanyEntity subCompanyEntity = new SubCompanyEntity();
        SubContractorEntity sub = new SubContractorEntity();
        subCompanyEntity.setId(id);
        subCompanyEntity.setFirstName(firstName);
        subCompanyEntity.setFirstName(lastName);
        String displayName = firstName + " " + lastName;
        subCompanyEntity.setDisplayName(displayName);
        subCompanyEntity.setSubContractorEntity(sub);
        return (SubCompanyEntity)this.companySubDAO.create(subCompanyEntity);
    }

    @Override
    public void deleteSubCompany(Long id) throws Exception {
        SubCompanyEntity subCompanyEntity = (SubCompanyEntity)this.companySubDAO.find(id);
        this.companySubDAO.delete(subCompanyEntity);
    }

    @Override
    public SubCompanyEntity getSubCompany(Long id) throws Exception {
        SubCompanyEntity subCompanyEntity = (SubCompanyEntity)this.companySubDAO.find(id);
        return subCompanyEntity;
    }

    @Override
    public SubCompanyEntity updateSubCompany(Long id, SubContractorEntity subContractorEntity, String firstName, String lastName) throws Exception {
        SubCompanyEntity subCompanyEntity = new SubCompanyEntity();
        SubContractorEntity sub = new SubContractorEntity();
        subCompanyEntity.setId(id);
        subCompanyEntity.setFirstName(firstName);
        subCompanyEntity.setFirstName(lastName);
        String displayName = firstName + " " + lastName;
        subCompanyEntity.setDisplayName(displayName);
        subCompanyEntity.setSubContractorEntity(sub);
        return (SubCompanyEntity)this.companySubDAO.update(subCompanyEntity);
    }
}

