/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.DAO;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ProjectSubDAO
extends GenericDAOJPAImpl<ProjectSubEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectSubDAO.class);

    public List<ProjectSubEntity> getRelationShipBySubId(String subId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findBySubId", ProjectSubEntity.class).setParameter("subId", (Object)subId).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findBySubId", ProjectSubEntity.class).setParameter("subId", (Object)subId).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and SubtId = '" + subId + "'."), (Throwable)e);
            throw e;
        }
    }

    public List<ProjectSubEntity> getRelationShipBySubCat(String subId, String catId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByCatSubId", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("catId", (Object)catId).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByCatSubId", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("catId", (Object)catId).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and SubtId = '" + subId + "' and CatId = '" + catId + "'."), (Throwable)e);
            throw e;
        }
    }

    public List<ProjectSubEntity> getRelationShipByProjectIdAndStatus(String projectId, String status, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdStatus", ProjectSubEntity.class).setParameter("projectId", (Object)projectId).setParameter("status", (Object)status).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdStatus", ProjectSubEntity.class).setParameter("projectId", (Object)projectId).setParameter("status", (Object)status).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and projectId = '" + projectId + "' and status = '" + status + "'."), (Throwable)e);
            throw e;
        }
    }

    public List<ProjectSubEntity> getRelationShipByProjectId(String projectId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectId", ProjectSubEntity.class).setParameter("projectId", (Object)projectId).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectId", ProjectSubEntity.class).setParameter("projectId", (Object)projectId).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and projectId = '" + projectId), (Throwable)e);
            throw e;
        }
    }

    public List<ProjectSubEntity> getRelationShipByProjectIdAndCatId(String projectId, String catId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdCatId", ProjectSubEntity.class).setParameter("projectId", (Object)projectId).setParameter("catId", (Object)catId).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdCatId", ProjectSubEntity.class).setParameter("projectId", (Object)projectId).setParameter("catId", (Object)catId).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and projectId = '" + projectId + "' and CatId = '" + catId), (Throwable)e);
            throw e;
        }
    }

    public List<ProjectSubEntity> getRelationShipBySubIdAndStatus(String subId, String status, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdStatus", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("status", (Object)status).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdStatus", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("status", (Object)status).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and subId = '" + subId + "' and status = '" + status), (Throwable)e);
            throw e;
        }
    }

    public ProjectSubEntity getRelationShip(String subId, String projectId, String catId) {
        return (ProjectSubEntity)this.getEntityManager().createNamedQuery("psProjectSubEntity.findAll", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("projectId", (Object)projectId).setParameter("catId", (Object)catId).getSingleResult();
    }

    public List<ProjectSubEntity> getRelationShipByProjectIdAndSubId(String projectId, String subId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdProjectId", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("projectId", (Object)projectId).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdProjectId", ProjectSubEntity.class).setParameter("subId", (Object)subId).setParameter("projectId", (Object)projectId).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'.' and subId = '" + subId + "' and projectId = '" + projectId), (Throwable)e);
            throw e;
        }
    }

    public int getRelationShipCountByProjectIdAndCatId(String projectId, String catId) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndCatId", Long.class).setParameter("projectId", (Object)projectId).setParameter("catId", (Object)catId).getSingleResult()).intValue();
    }

    public int getRelationShipCountBySubId(String subId) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountBySubId", Long.class).setParameter("subId", (Object)subId).getSingleResult()).intValue();
    }

    public int getRelationShipCountByProjectId(String projectId) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectId", Long.class).setParameter("projectId", (Object)projectId).getSingleResult()).intValue();
    }

    public int getRelationShipsCountbyProjectIdCatIdAndstatus(String projectId, String catId, String status) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdCatIdAndstatus", Long.class).setParameter("projectId", (Object)projectId).setParameter("catId", (Object)catId).setParameter("status", (Object)status).getSingleResult()).intValue();
    }

    public int getRelationShipCountByProjectIdAndSubId(String projectId, String subId) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndSubId", Long.class).setParameter("projectId", (Object)projectId).setParameter("subId", (Object)subId).getSingleResult()).intValue();
    }

    public int getRelationShipCountBySubIdAndStatus(String subId, String status) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountBySubIdAndStatus", Long.class).setParameter("subId", (Object)subId).setParameter("status", (Object)status).getSingleResult()).intValue();
    }

    public int getRelationShipCountByProjectIdAndStatus(String projectId, String status) {
        return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndStatus", Long.class).setParameter("projectId", (Object)projectId).setParameter("status", (Object)status).getSingleResult()).intValue();
    }

    public int getRelationShipCountByProjectIdAndSearchConditions(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String projectId) {
        try {
            return ((Long)this.getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndStatus", Long.class).setParameter("projectId", (Object)projectId).getSingleResult()).intValue();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while attempting ", (Throwable)e);
            throw e;
        }
    }
}

