/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.entity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.social.common.ListAccessValidator;

public class ProjectSubListAccess
implements ListAccess<ProjectSubEntity> {
    String param1;
    String param2;
    boolean isInvitedTable;
    boolean isVendor;
    boolean isMessaged;
    String searchCondition;
    List<String> SearchConditions;
    List<ProjectSubEntity> include;
    String sortBy;
    String sortDir;
    String projectId;
    Type type;
    private ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);

    public ProjectSubListAccess(String param1, Type type) {
        this.param1 = param1;
        this.type = type;
    }

    public ProjectSubListAccess(String param1, String param2, Type type) {
        this.param1 = param1;
        this.param2 = param2;
        this.type = type;
    }

    public ProjectSubListAccess(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String sortBy, String sortDir, String projectId, Type type) {
        this.isInvitedTable = isInvitedTable;
        this.isVendor = isVendor;
        this.isMessaged = isMessaged;
        this.searchCondition = searchCondition;
        this.SearchConditions = SearchConditions;
        this.include = include;
        this.sortBy = sortBy;
        this.sortDir = sortDir;
        this.projectId = projectId;
        this.type = type;
    }

    public ProjectSubEntity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List<ProjectSubEntity> relations = null;
        switch (this.type) {
            case SUBID: {
                relations = this.projectSubRelationShipStorage.getRelationShipBySubId(this.param1, offset, limit);
                break;
            }
            case PROJECTID: {
                relations = this.projectSubRelationShipStorage.getRelationShipByProjectId(this.param1, offset, limit);
                break;
            }
            case PROJECTID_SEARCH: {
                relations = this.projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchConditions(this.isInvitedTable, this.isVendor, this.isMessaged, this.searchCondition, this.SearchConditions, this.include, this.sortBy, this.sortDir, this.projectId, offset, limit);
                break;
            }
            case SUBID_STATUS: {
                relations = this.projectSubRelationShipStorage.getRelationShipBySubIdAndStatus(this.param1, this.param2, offset, limit);
                break;
            }
            case PROJECTID_STATUS: {
                relations = this.projectSubRelationShipStorage.getRelationShipByProjectIdAndStatus(this.param1, this.param2, offset, limit);
                break;
            }
            case PROJECTID_SUBID: {
                relations = this.projectSubRelationShipStorage.getRelationShipByProjectIdAndSubId(this.param1, this.param2, offset, limit);
                break;
            }
            case PROJECTID_CATID: {
                relations = this.projectSubRelationShipStorage.getRelationShipByProjectIdAndCatId(this.param1, this.param2, offset, limit);
            }
        }
        return relations.toArray(new ProjectSubEntity[relations.size()]);
    }

    public int getSize() throws Exception {
        switch (this.type) {
            case SUBID: {
                return this.projectSubRelationShipStorage.getRelationShipCountBySubId(this.param1);
            }
            case PROJECTID: {
                return this.projectSubRelationShipStorage.getRelationShipCountByProjectId(this.param1);
            }
            case PROJECTID_SEARCH: {
                return this.projectSubRelationShipStorage.getRelationShipCountByProjectIdAndSearchConditions(this.isInvitedTable, this.isVendor, this.isMessaged, this.searchCondition, this.SearchConditions, this.include, this.projectId);
            }
            case SUBID_STATUS: {
                return this.projectSubRelationShipStorage.getRelationShipCountBySubIdAndStatus(this.param1, this.param2);
            }
            case PROJECTID_SUBID: {
                return this.projectSubRelationShipStorage.getRelationShipCountByProjectIdAndSubId(this.param1, this.param2);
            }
            case PROJECTID_STATUS: {
                return this.projectSubRelationShipStorage.getRelationShipCountByProjectIdAndStatus(this.param1, this.param2);
            }
            case PROJECTID_CATID: {
                return this.projectSubRelationShipStorage.getRelationShipCountByProjectIdAndCatId(this.param1, this.param2);
            }
        }
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        SUBID,
        PROJECTID,
        PROJECTID_SEARCH,
        SUBID_STATUS,
        PROJECTID_STATUS,
        PROJECTID_SUBID,
        PROJECTID_CATID;

    }
}

