/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.reporting;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.ps.rest.ProjectRestService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.service.rest.Util;

@Path(value="/bbreportingservice")
public class ReportingService
implements ResourceContainer {
    private static final String SOCIAL_WORKSPACE = "social";
    private static final String TOTAL_VISITS = "exo:totalVisits";
    private static final String LAST_VISIT = "exo:lastVisit";
    private static final String TOTAL_VIEWS = "exo:totalViews";
    private static final String TOTAL_DOWNLOADS = "exo:totalDownloads";
    private static final Log LOG = ExoLogger.getLogger((String)ProjectRestService.class.getName());
    private static final String SUBS_GROUP = "/organization/subcontractors";
    private RepositoryService repositoryService;
    private SettingService settingService;
    private static final String BASE_URL = "baseUrl";

    public ReportingService(RepositoryService repositoryService, SettingService settingService) {
        this.repositoryService = repositoryService;
        this.settingService = settingService;
    }

    @POST
    @Path(value="planRoomReporting/{projectName}")
    public Response planRoomReporting(@PathParam(value="projectName") String projectName) {
        try {
            Identity currentUserIdentity;
            if (this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BASE_URL) == null) {
                this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BASE_URL, SettingValue.create((String)Util.getBaseUrl()));
            }
            if ((currentUserIdentity = ConversationState.getCurrent().getIdentity()).isMemberOf(SUBS_GROUP)) {
                Node userReportingNode;
                Node projectReportingNode;
                Node reportingNode;
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = manageableRepository.getSystemSession(SOCIAL_WORKSPACE);
                Node socialProductionNode = (Node)session.getItem("/production");
                if (!socialProductionNode.hasNode("reporting")) {
                    socialProductionNode.addNode("reporting", "exo:reporting");
                    session.save();
                }
                if (!(reportingNode = socialProductionNode.getNode("reporting")).hasNode(projectName)) {
                    reportingNode.addNode(projectName, "exo:projectReporting");
                    session.save();
                }
                if (!(projectReportingNode = reportingNode.getNode(projectName)).hasNode(currentUserIdentity.getUserId())) {
                    projectReportingNode.addNode(currentUserIdentity.getUserId(), "exo:userReporting");
                    session.save();
                }
                if (!(userReportingNode = projectReportingNode.getNode(currentUserIdentity.getUserId())).hasProperty(TOTAL_VISITS)) {
                    userReportingNode.setProperty(TOTAL_VISITS, 1L);
                } else {
                    int totalVisitValue = Integer.parseInt(userReportingNode.getProperty(TOTAL_VISITS).getString()) + 1;
                    userReportingNode.setProperty(TOTAL_VISITS, (long)totalVisitValue);
                }
                session.save();
                SimpleDateFormat formater = new SimpleDateFormat("MM/dd/yy");
                userReportingNode.setProperty(LAST_VISIT, formater.format(new Date()));
                session.save();
            }
            return Response.ok((Object)"VisitsReported").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    public void docViewsReporting(Node node) {
        Identity currentUserIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (currentUserIdentity.isMemberOf(SUBS_GROUP)) {
                this.docReporting(node, currentUserIdentity.getUserId(), TOTAL_VIEWS);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void docDownloadsReporting(Node node) {
        Identity currentUserIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (currentUserIdentity.isMemberOf(SUBS_GROUP)) {
                this.docReporting(node, currentUserIdentity.getUserId(), TOTAL_DOWNLOADS);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void docReporting(Node node, String user, String operation) throws Exception {
        Node docReportingNode;
        Node userReportingNode;
        Node projectReportingNode;
        String project;
        Node reportingNode;
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = manageableRepository.getSystemSession(SOCIAL_WORKSPACE);
        Node socialProductionNode = (Node)session.getItem("/production");
        if (!socialProductionNode.hasNode("reporting")) {
            socialProductionNode.addNode("reporting", "exo:reporting");
            session.save();
        }
        if (!(reportingNode = socialProductionNode.getNode("reporting")).hasNode(project = node.getPath().split("/Groups/spaces/")[1].split("/Documents")[0])) {
            reportingNode.addNode(project, "exo:projectReporting");
            session.save();
        }
        if (!(projectReportingNode = reportingNode.getNode(project)).hasNode(user)) {
            projectReportingNode.addNode(user, "exo:userReporting");
            session.save();
        }
        if (!(userReportingNode = projectReportingNode.getNode(user)).hasNode(node.getUUID())) {
            userReportingNode.addNode(node.getUUID(), "exo:docReporting");
            session.save();
        }
        if (!(docReportingNode = userReportingNode.getNode(node.getUUID())).hasProperty(operation)) {
            docReportingNode.setProperty(operation, 1L);
        } else {
            int operationValue = Integer.parseInt(docReportingNode.getProperty(operation).getString()) + 1;
            docReportingNode.setProperty(operation, (long)operationValue);
        }
        session.save();
    }
}

