/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.json.JSONArray;

@Path(value="/bbasservice")
public class ASRestService
implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String GCS_GROUP = "/organization/gcs";
    private static final Log LOG = ExoLogger.getLogger((String)ASRestService.class.getName());
    OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);

    @GET
    @Path(value="getGroupMembers/{group}/{isGCReceiver}")
    public Response getGroupMembers(@PathParam(value="group") String group, @PathParam(value="isGCReceiver") boolean isGCReceiver, @QueryParam(value="term") String term) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (String groupMember : this.getGroupMembers(group, isGCReceiver)) {
            if (!groupMember.toLowerCase().contains(term.toLowerCase())) continue;
            jsonArray.put((Object)groupMember);
        }
        return Response.ok((Object)jsonArray.toString(), (MediaType)mediaType).build();
    }

    public List<String> getGroupMembers(String group, boolean isGCReceiver) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        ArrayList<String> groupMembers = new ArrayList<String>();
        for (String groupId : group.split(";")) {
            ListAccess users = groupId.equals("gcs") ? this.orgService.getUserHandler().findUsersByGroupId(GCS_GROUP) : this.orgService.getUserHandler().findUsersByGroupId("/spaces/" + groupId);
            for (User user : (User[])users.load(0, users.getSize())) {
                if (user.getUserName().equals(sourceIdentity.getRemoteId()) || this.isGCMember(user.getUserName()) && this.isGCMember(sourceIdentity.getRemoteId()) || isGCReceiver && (!isGCReceiver || !this.isGCMember(user.getUserName()))) continue;
                if (this.isGCMember(user.getUserName())) {
                    groupMembers.add(user.getFullName() + "(Internal Employees)");
                    continue;
                }
                SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(user.getUserName());
                groupMembers.add(user.getDisplayName() + "(" + userInfo.getCompany() + ")");
            }
        }
        return groupMembers;
    }

    private boolean isGCMember(String userName) throws Exception {
        Collection groupsList = this.orgService.getGroupHandler().findGroupsOfUser(userName);
        for (Group group : groupsList) {
            if (!group.getId().equals(GCS_GROUP)) continue;
            return true;
        }
        return false;
    }
}

