/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.ps.DTO.ProjectRelClone;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.model.BbMessage;
import org.exoplatform.ps.rest.SubCatRunner;
import org.exoplatform.ps.rest.UsersRestService;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.RelationShipType;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

public class MessagingRunner
implements Runnable {
    private static final Log LOG = ExoLogger.getLogger((String)MessagingRunner.class.getName());
    private static Boolean requestStarted = false;
    OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    private Space project;
    private String projectId;
    private String portalContainerName;
    private BbFilteredSearchRequest searchRequest;
    private BbMessage bbMessage;
    private Identity sourceIdentity;
    private boolean nonMessageOnly;
    private boolean sendAll;
    private String host;
    private String bidScop;
    private ConversationState myConversationState;

    MessagingRunner(Space project, String portalContainerName, BbMessage message, Identity sourceIdentity, boolean nonMessageOnly, String host, String bidScop, ConversationState conversationState) {
        this.project = project;
        this.projectId = message.getProjectId();
        this.portalContainerName = portalContainerName;
        this.searchRequest = message.getFilteredSearchRequest();
        this.searchRequest.setSubcats(message.getRelations());
        this.bbMessage = message;
        this.bbMessage.setAddNonInv(true);
        this.bbMessage.setRelations(message.getRelations());
        this.sourceIdentity = sourceIdentity;
        this.nonMessageOnly = nonMessageOnly;
        this.sendAll = this.searchRequest.isSendAllMessages();
        this.myConversationState = conversationState;
        this.host = host;
        this.bidScop = bidScop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info((Object)"Messaging Runner Thread started - Preparing to send messages");
        SubCatRunner subCatRunner = null;
        subCatRunner = this.nonMessageOnly ? new SubCatRunner(this.project, this.projectId, this.portalContainerName, this.searchRequest, RelationShipType.GET_NON_MESS, this.myConversationState) : (this.searchRequest.getsSearch_4().equalsIgnoreCase("INVITED") ? new SubCatRunner(this.project, this.projectId, this.portalContainerName, this.searchRequest, RelationShipType.INVITED_MESS, this.myConversationState) : new SubCatRunner(this.project, this.projectId, this.portalContainerName, this.searchRequest, RelationShipType.PROJECT_SUB, this.myConversationState));
        ArrayList<ProjectRelClone> myNonMsgd = new ArrayList<ProjectRelClone>();
        subCatRunner.setNonMessaged(myNonMsgd);
        Thread createSubCatRelation = new Thread((Runnable)subCatRunner, "Sub Cat Runner Thread");
        createSubCatRelation.start();
        while (subCatRunner.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("Error while processing messages. {}", new Object[]{e.getMessage()});
            }
        }
        try {
            if (myNonMsgd.size() > 0) {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                ConversationState.setCurrent((ConversationState)this.myConversationState);
                LOG.info((Object)("Conversation state messaging:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
                LOG.info((Object)("PortalContainer messaging:   " + PortalContainer.getInstance().getName()));
                this.sendMessage(this.bbMessage, myNonMsgd, this.host, this.bidScop);
            }
        }
        catch (Exception e) {
            LOG.error("Error while sending messages. {}", new Object[]{e.getMessage()});
        }
        finally {
            LOG.info((Object)"Messaging Runner Thread ended - Message send complete.");
            if (myNonMsgd.size() > 0) {
                RequestLifeCycle.end();
            }
        }
    }

    private void startRequest() {
        if (this.orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.orgService).startRequest((ExoContainer)PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    private void endRequest() {
        if (requestStarted.booleanValue() && this.orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.orgService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            requestStarted = false;
        }
    }

    public synchronized void sendMessage(BbMessage message, List<ProjectRelClone> relationShipsList, String host, String bidScop) throws Exception {
        SpaceService spaceService = Util.getSpaceService((String)this.portalContainerName);
        OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        UserHandler uh = orgService.getUserHandler();
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        String subject = message.getSubject();
        Boolean isDaily = message.getIsDaily();
        Boolean addNonInv = message.getAddNonInv();
        Boolean updateEvent = message.getUpdateEvent();
        String newEventDate = message.getNewEventDate();
        String projectId = message.getProjectId();
        String mailText = message.getMailText();
        try {
            Space project = null;
            if (addNonInv != null && addNonInv.booleanValue() && projectId != null && (project = spaceService.getSpaceByPrettyName(projectId)) == null) {
                throw new Exception("Project not found");
            }
            for (ProjectRelClone rel_ : relationShipsList) {
                User user_ = uh.findUserByName(rel_.getSubId());
                if (user_ == null) {
                    LOG.info((Object)(rel_.getSubId() + " Not yet created sub by the thread import, will try to create it before messaging "));
                    this.startRequest();
                    MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
                    GroupHandler gHandler = orgService.getGroupHandler();
                    MembershipHandler mHandler = orgService.getMembershipHandler();
                    ((ComponentRequestLifecycle)orgService).startRequest((ExoContainer)PortalContainer.getInstance());
                    SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
                    SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(rel_.getSubId());
                    user_ = uh.createUserInstance(rel_.getSubId());
                    user_.setDisplayName(subUserInfo.getDisplayName());
                    if (orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                        user_.setPassword(Utils.getMd5(rel_.getSubId()));
                    } else {
                        user_.setPassword(rel_.getSubId());
                    }
                    user_.setEmail(subUserInfo.getEmail().toLowerCase());
                    user_.setLastName(subUserInfo.getLastName());
                    user_.setFirstName(subUserInfo.getFirstName());
                    Date now = new Date();
                    user_.setCreatedDate(now);
                    uh.createUser(user_, false);
                    Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                    mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                    Group usersGroup = gHandler.findGroupById("/platform/users");
                    mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                    LOG.info((Object)("SubContractor " + subUserInfo.getDisplayName() + " imported"));
                    this.endRequest();
                }
                String to = user_.getUserName();
                String mailText_ = mailText;
                String trbidbuttons = "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n";
                trbidbuttons = trbidbuttons + "                                <tr><td colspan=\"3\" height=\"5\"><span>" + rel_.getCatCsiDesc() + "</span></td></tr>\n                                <tr>\n                                  <td align=\"right\" valign=\"middle\"><a href=\"" + host + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCatId() + "/" + user_.getUserName() + "/NOT_BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n                                  </td>\n                                  <td align=\"center\" valign=\"middle\"><a href=\"" + host + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCatId() + "/" + user_.getUserName() + "/UNDECIDED\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n                                  </td>\n                                  <td align=\"left\" valign=\"middle\"><a href=\"" + host + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCatId() + "/" + user_.getUserName() + "/BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n";
                trbidbuttons = trbidbuttons + "                                <tr>\n                                </tr>\n                              </table>\n";
                mailText_ = mailText_.replace("{|CATID|}", trbidbuttons);
                mailText_ = mailText_.replace("{|RECEIVERID|}", rel_.getSubId());
                mailText_ = mailText_.replace("{|RECEIVERFIRSTNAME|}", user_.getFirstName());
                mailText_ = mailText_.replace("{|RECEIVERLASTNAME|}", user_.getLastName());
                if (!UsersRestService.sendMail(to, subject, mailText_ = mailText_.replace("{|CLASSIFICATION|}", rel_.getCatCsiDesc()), isDaily)) continue;
                if (addNonInv != null && addNonInv.booleanValue() && project != null) {
                    try {
                        IdentityManager identityManager = Util.getIdentityManager((String)this.portalContainerName);
                        identityManager.getOrCreateIdentity("organization", rel_.getSubId(), true);
                        Utils.addToSpace(project, rel_.getSubId());
                        projectSubRelationShipStorage.updateProjectSubRelationShip(rel_.getId(), null, "INVITED", null, null, null, bidScop);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (updateEvent != null && updateEvent.booleanValue()) {
                    CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    String CalendarId = project.getPrettyName() + "_space_calendar";
                    SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                    Date duedate = formatter.parse(String.valueOf(newEventDate));
                    CalendarEvent duedateevent = calService.getEventById(project.getPrettyName() + " - bidsDueDate");
                    duedateevent.setFromDateTime(duedate);
                    duedateevent.setToDateTime(duedate);
                    duedateevent.setDescription(project.getDescription());
                    calService.savePublicEvent(CalendarId, duedateevent, false);
                }
                LOG.info((Object)("message is already sent to " + user_.getDisplayName() + " email= " + user_.getEmail().toLowerCase()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

