/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.ps.DTO.ProjectRelClone;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.exoplatform.ps.entity.SubGroupEntity;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.storage.api.BBCategoryStorage;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.ps.storage.api.SubCatGroupRelationStorage;
import org.exoplatform.ps.storage.api.SubCatStorage;
import org.exoplatform.ps.storage.api.SubGroupStorage;
import org.exoplatform.ps.utils.RelationShipType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

public class SubCatRunner
implements Runnable {
    private static final Log LOG = ExoLogger.getLogger((String)SubCatRunner.class.getName());
    private List<String> subcats = new ArrayList<String>(1);
    private String addtoselected = null;
    private BbFilteredSearchRequest searchRequest;
    private RelationShipType relationShipType;
    private Space project;
    private String projectId;
    private String portalContainerName;
    private boolean isRunning = true;
    private List<ProjectRelClone> nonMessaged = new ArrayList<ProjectRelClone>(1);
    private ConversationState myConversationState;

    SubCatRunner(BbFilteredSearchRequest searchRequest, RelationShipType relationShipType, ConversationState conversationState) {
        this.subcats = searchRequest.getSubcats();
        this.searchRequest = searchRequest;
        this.relationShipType = relationShipType;
        this.myConversationState = conversationState;
    }

    SubCatRunner(String addtoselected, BbFilteredSearchRequest searchRequest, RelationShipType relationShipType, ConversationState conversationState) {
        this.subcats = searchRequest.getSubcats();
        this.addtoselected = addtoselected;
        this.searchRequest = searchRequest;
        this.relationShipType = relationShipType;
        this.myConversationState = conversationState;
    }

    SubCatRunner(Space project, String projectId, String portalContainerName, BbFilteredSearchRequest searchRequest, RelationShipType relationShipType, ConversationState conversationState) {
        this.subcats = searchRequest.getSubcats();
        this.searchRequest = searchRequest;
        this.relationShipType = relationShipType;
        this.project = project;
        this.projectId = projectId;
        this.portalContainerName = portalContainerName;
        this.myConversationState = conversationState;
    }

    @Override
    public void run() {
        if (RelationShipType.SUB_CAT == this.relationShipType) {
            this.processSubCatGroups();
        } else if (RelationShipType.PROJECT_SUB == this.relationShipType) {
            this.processProjectSub(true);
        } else if (RelationShipType.GET_NON_MESS == this.relationShipType) {
            this.processProjectSub(false);
        } else if (RelationShipType.DELETE_ALL == this.relationShipType) {
            this.deleteAll(true);
        } else if (RelationShipType.CANCEL_REJECT == this.relationShipType) {
            this.deleteAll(false);
        } else if (RelationShipType.INVITED_MESS == this.relationShipType) {
            this.processProjectSub(false);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setNonMessaged(List<ProjectRelClone> nonMessaged) {
        this.nonMessaged = nonMessaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deleteAll(boolean fullDelete) {
        block35: {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            LOG.info((Object)"Sub Cat Runner Thread started - Deleting Users");
            ConversationState.setCurrent((ConversationState)this.myConversationState);
            LOG.debug((Object)("is fullDelete is set to :" + fullDelete));
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
            UserHandler uh = orgService.getUserHandler();
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(this.searchRequest.getsSearch_1());
            SearchConditions.add(this.searchRequest.getsSearch_2());
            SearchConditions.add(this.searchRequest.getsSearch_3());
            SearchConditions.add(this.searchRequest.getsSearch_4());
            SearchConditions.add(this.searchRequest.getsSearch_5());
            SearchConditions.add(this.searchRequest.getsSearch_6());
            SearchConditions.add(this.searchRequest.getsSearch_7());
            SearchConditions.add(this.searchRequest.getsSearch_9());
            SearchConditions.add(this.searchRequest.getsSearch_10());
            SearchConditions.add(this.searchRequest.getSearchsubs());
            int total = 0;
            int numToProcess = 100;
            int lastProcessed = 0;
            int numProcessed = 0;
            int numRemaining = 0;
            try {
                Identity sourceIdentity = null;
                SpaceService spaceService = null;
                if (null != this.projectId) {
                    sourceIdentity = Util.getAuthenticatedUserIdentity((String)this.portalContainerName);
                    spaceService = Util.getSpaceService((String)this.portalContainerName);
                }
                if (!fullDelete) {
                    List<String> filteredgroups = this.searchRequest.getFilteredGroups();
                    if (filteredgroups != null && filteredgroups.size() > 0) {
                        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                        for (String filteredgroup : filteredgroups) {
                            List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                            for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                                ProjectSubEntity relationShip = null;
                                try {
                                    relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), this.projectId, subCatGroupRelation.getCategory().getId());
                                    if (this.subcats.contains(relationShip.getId()) || !relationShip.getStatus().equalsIgnoreCase((String)SearchConditions.get(3))) continue;
                                    if (null != this.project && projectSubRelationShipStorage.getRelationShipCountBySubId(subCatGroupRelation.getSubContractor().getId()) == 0) {
                                        if (spaceService.isInvitedUser(this.project, relationShip.getSubContractor().getId())) {
                                            spaceService.removeInvitedUser(this.project, relationShip.getSubContractor().getId());
                                        } else if (spaceService.isMember(this.project, relationShip.getSubContractor().getId())) {
                                            spaceService.removeMember(this.project, relationShip.getSubContractor().getId());
                                        }
                                    }
                                    projectSubRelationShipStorage.deleteProjectSubRelationShip(relationShip.getId());
                                }
                                catch (Exception e) {
                                    LOG.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    } else {
                        ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<ProjectSubEntity>(1), "tbb:subId", "asc", this.projectId);
                        LOG.debug((Object)relList.getSize());
                        for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                            if (null != this.project && projectSubRelationShipStorage.getRelationShipCountBySubId(sub.getSubContractor().getId()) == 0) {
                                if (spaceService.isInvitedUser(this.project, sub.getSubContractor().getId())) {
                                    spaceService.removeInvitedUser(this.project, sub.getSubContractor().getId());
                                } else if (spaceService.isMember(this.project, sub.getSubContractor().getId())) {
                                    spaceService.removeMember(this.project, sub.getSubContractor().getId());
                                }
                            }
                            projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                        }
                    }
                    break block35;
                }
                if (this.searchRequest.getSubSelect().size() != 0) break block35;
                total = subCatStorage.subCatSearchCount(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                List<SubCatEntity> subCatList = subCatStorage.subCatSearch(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                LOG.debug((Object)subCatList.size());
                BBCategoryStorage bbCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
                ArrayList<String> names = new ArrayList<String>(1);
                for (SubCatEntity subcat : subCatList) {
                    names.add(subcat.getSubContractor().getId());
                }
                while (subCatList.size() > 0) {
                    for (String uName : names) {
                        if (this.subcats.contains(uName)) continue;
                        ListAccess<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdListAccess(uName);
                        for (ProjectSubEntity sub : (ProjectSubEntity[])sublist.load(0, sublist.getSize())) {
                            if (projectSubRelationShipStorage.getRelationShipCountBySubId(sub.getSubContractor().getId()) == 0 && null != this.project) {
                                if (spaceService.isInvitedUser(this.project, sub.getSubContractor().getId())) {
                                    spaceService.removeInvitedUser(this.project, sub.getSubContractor().getId());
                                } else if (spaceService.isMember(this.project, sub.getSubContractor().getId())) {
                                    spaceService.removeMember(this.project, sub.getSubContractor().getId());
                                }
                            }
                            projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                        }
                        LOG.info((Object)"Relationship Removed");
                        List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(uName, 0, 0);
                        for (SubCatEntity subcat : subcats) {
                            bbCategoryStorage.deleteBBCategory(subcat.getCategory().getId());
                            subCatStorage.deleteSubCat(subcat.getCategory().getId());
                        }
                        User user = uh.findUserByName(uName);
                        if (user == null) {
                            LOG.warn((Object)(uName + " user name don't exists"));
                            continue;
                        }
                        user.setPassword("pass");
                        LOG.info((Object)"SubContractor  deleted");
                    }
                    ++numProcessed;
                    if (++lastProcessed >= total) {
                        break;
                    }
                    if (numProcessed < numToProcess && numProcessed < numRemaining) continue;
                    RequestLifeCycle.end();
                    Thread.sleep(1000L);
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    numProcessed = 0;
                    subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                    projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
                    if (null != this.projectId) {
                        sourceIdentity = Util.getAuthenticatedUserIdentity((String)this.portalContainerName);
                        spaceService = Util.getSpaceService((String)this.portalContainerName);
                    }
                    bbCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
                    subCatList.clear();
                    names.clear();
                    subCatList = subCatStorage.subCatSearch(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", 0L, numToProcess);
                    numRemaining = subCatList.size();
                    for (SubCatEntity subcat : subCatList) {
                        names.add(subcat.getSubContractor().getId());
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error while processing subCats. {}", new Object[]{e.getMessage()});
            }
            finally {
                LOG.info((Object)"Sub Cat Runner Thread ended - Deleted Users");
                RequestLifeCycle.end();
                this.isRunning = false;
            }
        }
    }

    private synchronized void buildInvitedMessList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processProjectSub(boolean createNonMess) {
        block28: {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            LOG.info((Object)"Sub Cat Runner Thread started - Creating Project Sub Relationships");
            ConversationState.setCurrent((ConversationState)this.myConversationState);
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            IdentityManager identityManager = Util.getIdentityManager((String)this.portalContainerName);
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(this.searchRequest.getsSearch_1());
            SearchConditions.add(this.searchRequest.getsSearch_2());
            SearchConditions.add(this.searchRequest.getsSearch_3());
            SearchConditions.add(this.searchRequest.getsSearch_4());
            SearchConditions.add(this.searchRequest.getsSearch_5());
            SearchConditions.add(this.searchRequest.getsSearch_6());
            SearchConditions.add(this.searchRequest.getsSearch_7());
            SearchConditions.add(this.searchRequest.getsSearch_9());
            SearchConditions.add(this.searchRequest.getsSearch_10());
            SearchConditions.add(this.searchRequest.getSearchsubs());
            int total = 0;
            int numToProcess = 100;
            int lastProcessed = 0;
            int numProcessed = 0;
            try {
                if (this.searchRequest.getFilteredGroups() != null && this.searchRequest.getFilteredGroups().size() > 0) {
                    SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                    ArrayList included = new ArrayList();
                    List<String> filteredgroups = this.searchRequest.getFilteredGroups();
                    if (filteredgroups == null || filteredgroups.size() <= 0) break block28;
                    for (String filteredgroup : filteredgroups) {
                        List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                        for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                            ProjectSubEntity relationShip;
                            block29: {
                                relationShip = null;
                                try {
                                    relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), this.projectId, subCatGroupRelation.getCategory().getId());
                                    if (this.subcats.contains(relationShip.getId())) {
                                        continue;
                                    }
                                }
                                catch (Exception e) {
                                    if (!createNonMess) break block29;
                                    if (subCatGroupRelation.getSubContractor().getId() != "" && subCatGroupRelation.getCategory().getId() != "") {
                                        SubCatEntity subcat = subCatStorage.getSubCat(subCatGroupRelation.getSubContractor().getId() + "_" + subCatGroupRelation.getCategory().getId());
                                        relationShip = projectSubRelationShipStorage.createProjectSubRelationShip(subcat, this.project.getPrettyName(), "NOT_MESS", "", subcat.getSubContractor().getRank(), "no");
                                        LOG.info((Object)("SubContractor " + subcat.getId() + " added to the project: " + this.project.getPrettyName()));
                                    } else {
                                        LOG.warn((Object)"Sub Id or category is null, relationship will not be created");
                                    }
                                    if (!relationShip.getStatus().equals("NOT_MESS")) break block29;
                                    this.nonMessaged.add(new ProjectRelClone(relationShip));
                                }
                            }
                            try {
                                if (createNonMess || relationShip == null || !relationShip.getStatus().equals(SearchConditions.get(3))) continue;
                                this.nonMessaged.add(new ProjectRelClone(relationShip));
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    break block28;
                }
                if (((String)SearchConditions.get(3)).equalsIgnoreCase("NOT_MESS") || ((String)SearchConditions.get(3)).equalsIgnoreCase("INVITED")) {
                    ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<ProjectSubEntity>(1), "tbb:subId", "asc", this.projectId);
                    LOG.debug((Object)relList.getSize());
                    for (ProjectSubEntity relationShip : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                        this.nonMessaged.add(new ProjectRelClone(relationShip));
                    }
                    break block28;
                }
                total = subCatStorage.subCatSearchCount(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                List<SubCatEntity> subCatList = subCatStorage.subCatSearch(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                LOG.debug((Object)subCatList.size());
                while (subCatList.size() > 0) {
                    for (SubCatEntity subcat : subCatList) {
                        ProjectSubEntity relationShip;
                        block30: {
                            if (this.subcats.contains(subcat.getId())) continue;
                            relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subcat.getSubContractor().getId(), this.projectId, subcat.getCategory().getId());
                                if (this.subcats.contains(relationShip.getId())) {
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                if (!createNonMess) break block30;
                                if (subcat.getSubContractor().getId() != "" && subcat.getCategory().getId() != "") {
                                    relationShip = projectSubRelationShipStorage.createProjectSubRelationShip(subcat, this.project.getPrettyName(), "NOT_MESS", "", subcat.getSubContractor().getRank(), "no");
                                    LOG.info((Object)("SubContractor " + subcat.getId() + " added to the project: " + this.project.getPrettyName()));
                                } else {
                                    LOG.warn((Object)"Sub Id or category is null, relationship will not be created");
                                }
                                if (!relationShip.getStatus().equals("NOT_MESS")) break block30;
                                this.nonMessaged.add(new ProjectRelClone(relationShip));
                            }
                        }
                        try {
                            if (!createNonMess && relationShip != null && relationShip.getStatus().equals("NOT_MESS")) {
                                this.nonMessaged.add(new ProjectRelClone(relationShip));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++numProcessed;
                        ++lastProcessed;
                    }
                    if (lastProcessed >= total) break;
                    if (this.nonMessaged.size() == Integer.parseInt(this.searchRequest.getTotRecords())) {
                        break;
                    }
                    if (numProcessed < numToProcess) continue;
                    RequestLifeCycle.end();
                    Thread.sleep(1000L);
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    numProcessed = 0;
                    subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                    projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
                    subCatList.clear();
                    subCatList = subCatStorage.subCatSearch(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                }
            }
            catch (Exception e) {
                LOG.error("Error while processing subCats. {}", new Object[]{e.getMessage()});
            }
            finally {
                LOG.info((Object)"Sub Cat Runner Thread ended - Created Project Sub Relationships");
                RequestLifeCycle.end();
                this.isRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processSubCatGroups() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        LOG.info((Object)"Sub Cat Runner Thread started - Creating Sub Cat Groups");
        ConversationState.setCurrent((ConversationState)this.myConversationState);
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubGroupStorage subGroupStorage = (SubGroupStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
        ArrayList<String> SearchConditions = new ArrayList<String>();
        SearchConditions.add(this.searchRequest.getsSearch_1());
        SearchConditions.add(this.searchRequest.getsSearch_2());
        SearchConditions.add(this.searchRequest.getsSearch_3());
        SearchConditions.add(this.searchRequest.getsSearch_4());
        SearchConditions.add(this.searchRequest.getsSearch_5());
        SearchConditions.add(this.searchRequest.getsSearch_6());
        SearchConditions.add(this.searchRequest.getsSearch_7());
        SearchConditions.add(this.searchRequest.getSearchsubs());
        SearchConditions.add(this.searchRequest.getsSearch_8());
        SearchConditions.add(this.searchRequest.getsSearch_9());
        int total = 0;
        int numToProcess = 100;
        int lastProcessed = 0;
        int numProcessed = 0;
        try {
            List<String> filteredgroups = this.searchRequest.getFilteredGroups();
            List<Object> subCatList = new ArrayList(1);
            if (filteredgroups != null && filteredgroups.size() > 0) {
                for (String filteredgroup : filteredgroups) {
                    if (!"ranked-vendors".equalsIgnoreCase(filteredgroup)) continue;
                    total = subCatStorage.subCatSearchCount(true, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                    subCatList = subCatStorage.subCatSearch(true, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                }
            } else {
                total = subCatStorage.subCatSearchCount(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                subCatList = subCatStorage.subCatSearch(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
            }
            String[] selectedarray = this.addtoselected.split(",");
            while (subCatList.size() > 0) {
                for (SubCatEntity subCatEntity : subCatList) {
                    String subcatId = subCatEntity.getId();
                    if (this.subcats.contains(subcatId)) continue;
                    for (String selectedgroup : selectedarray) {
                        SubGroupEntity subGroup = subGroupStorage.getSubGroup(selectedgroup);
                        subCatGroupRelationStorage.createSubCatGroupRelation(selectedgroup, subcatId, subCatEntity.getSubContractor().getId(), subCatEntity.getSubContractor().getDisplayName(), subCatEntity.getCategory().getId(), subCatEntity.getCategory().getCatCsiDesc(), subGroup.getSubGroupName());
                    }
                    LOG.info((Object)("SubContractor " + subcatId + " added to the groups: " + this.addtoselected));
                    ++numProcessed;
                    ++lastProcessed;
                }
                if (lastProcessed >= total) {
                    break;
                }
                if (numProcessed < numToProcess) continue;
                RequestLifeCycle.end();
                Thread.sleep(1000L);
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                numProcessed = 0;
                subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                subGroupStorage = (SubGroupStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
                subCatList.clear();
                subCatList = subCatStorage.subCatSearch(false, this.searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
            }
        }
        catch (Exception e) {
            LOG.error("Error while processing subCats. {}", new Object[]{e.getMessage()});
        }
        finally {
            LOG.info((Object)"Sub Cat Runner Thread ended - Created Sub Cat Groups");
            RequestLifeCycle.end();
            this.isRunning = false;
        }
    }
}

