/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.storage.impl;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.ps.DAO.SubCatDAO;
import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubCatStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;

public class SubCatStorageImpl
extends AbstractStorage
implements SubCatStorage {
    private static final Log LOG = ExoLogger.getLogger(SubCatStorageImpl.class);
    private SubCatDAO subCatDAO = new SubCatDAO();

    public SubCatStorageImpl(SubCatDAO subCatDAO) {
        this.subCatDAO = subCatDAO;
    }

    @Override
    public SubCatEntity createSubCat(String subId, String catId, SubContractorEntity userProfile, String subRank, String catAbrDesc, String catFullDesc, String catCsiDesc) throws Exception {
        SubCatEntity subCatEntity = new SubCatEntity();
        CategoryEntity cat = new CategoryEntity();
        SubContractorEntity sub = new SubContractorEntity();
        String subcatId = sub.getId() + "_" + cat.getId();
        subCatEntity.setId(subcatId);
        subCatEntity.setCategory(cat);
        subCatEntity.setSubContractor(sub);
        subCatEntity.getSubContractor().setRank(subRank);
        return (SubCatEntity)this.subCatDAO.create(subCatEntity);
    }

    @Override
    public SubCatEntity createSubCat(String subcatId, CategoryEntity cat, SubContractorEntity sub, String subRank) throws Exception {
        SubCatEntity subCatEntity = new SubCatEntity();
        new SubCatEntity();
        subcatId = sub.getId() + "_" + cat.getId();
        if (this.subCatDAO.find((Serializable)((Object)subcatId)) == null) {
            subCatEntity.setId(subcatId);
            subCatEntity.setCategory(cat);
            subCatEntity.setSubContractor(sub);
            subCatEntity.getSubContractor().setRank(subRank);
            return (SubCatEntity)this.subCatDAO.create(subCatEntity);
        }
        return null;
    }

    @Override
    public void deleteSubCat(String id) throws Exception {
        SubCatEntity subCatEntity = (SubCatEntity)this.subCatDAO.find((Serializable)((Object)id));
        this.subCatDAO.delete(subCatEntity);
    }

    @Override
    public void updateSubCat(String subCatName, SubContractorEntity userProfile, String subRank) throws Exception {
        SubCatEntity subCatEntity = new SubCatEntity();
        if (subCatEntity != null) {
            if (subRank != null) {
                subCatEntity.getSubContractor().setRank(subRank);
            }
            if (userProfile != null) {
                this.subCatDAO.update(subCatEntity);
            }
        }
    }

    @Override
    public SubCatEntity getSubCat(String id) throws Exception {
        SubCatEntity subCatEntity = (SubCatEntity)this.subCatDAO.find((Serializable)((Object)id));
        return subCatEntity;
    }

    @Override
    public List<SubCatEntity> getSubCatsBySubId(String subId, int offset, int limit) throws Exception {
        return this.subCatDAO.getSubCatBySubId(subId, offset, limit);
    }

    @Override
    public List<SubCatEntity> getSubCatsByCatId(String catId, int offset, int limit) throws Exception {
        return this.subCatDAO.getSubCatByCatId(catId, offset, limit);
    }

    @Override
    public List<SubCatEntity> subCatSearch(boolean isVendor, String searchCondition, List<String> SearchConditions, List<SubCatEntity> excluded, List<SubCatEntity> include, String orderBy, String order, long offset, long limit) throws Exception {
        return this.subCatDAO.findAll();
    }

    @Override
    public int subCatSearchCount(boolean isVendor, String searchCondition, List<String> SearchConditions, List<SubCatEntity> excluded, List<SubCatEntity> include) throws Exception {
        return this.subCatDAO.subCatSearchCount();
    }
}

