/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.utils;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.picocontainer.Startable;

public class UpgradeService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)portalContainer.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        RepositoryService repositoryService = (RepositoryService)portalContainer.getComponentInstanceOfType(RepositoryService.class);
        Session session = null;
        try {
            ManageableRepository repository = repositoryService.getCurrentRepository();
            SessionProviderService sessionProviderService = (SessionProviderService)portalContainer.getComponentInstanceOfType(SessionProviderService.class);
            SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
            session = sProvider.getSession(lifeCycle.getWorkspaceName(), repository);
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            try {
                NodeType nodeType = nodeTypeManager.findNodeType(InternalQName.parse((String)"[http://www.exoplatform.org/jcr/tbb/1.0/]projectSubRelationShip"));
                Boolean exist = false;
                for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                    if (!propertyDefinition.getName().equals("tbb:bidScoped")) continue;
                    exist = true;
                    break;
                }
                if (!exist.booleanValue()) {
                    LOG.info((Object)"Update BBN nodeTypes");
                    nodeTypeManager.registerNodeTypes(this.getModelIS(), 4, "text/xml");
                    session.save();
                }
            }
            catch (IllegalNameException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    public void stop() {
    }

    public InputStream getModelIS() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/portal/tbb-chromattic-nodetypes.xml");
    }
}

