/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.channel.template;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.channel.template.WebTemplateProvider;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="ActivityCommentPlugin", template="war:/push-notifications/templates/ActivityCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityReplyToCommentPlugin", template="war:/push-notifications/templates/ActivityReplyToCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityMentionPlugin", template="war:/push-notifications/templates/ActivityMentionPlugin.gtmpl"), @TemplateConfig(pluginId="LikePlugin", template="war:/push-notifications/templates/LikePlugin.gtmpl"), @TemplateConfig(pluginId="LikeCommentPlugin", template="war:/push-notifications/templates/LikeCommentPlugin.gtmpl"), @TemplateConfig(pluginId="NewUserPlugin", template="war:/push-notifications/templates/NewUserPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivityPlugin", template="war:/push-notifications/templates/PostActivityPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivitySpaceStreamPlugin", template="war:/push-notifications/templates/PostActivitySpaceStreamPlugin.gtmpl"), @TemplateConfig(pluginId="RelationshipReceivedRequestPlugin", template="war:/push-notifications/templates/RelationshipReceivedRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestJoinSpacePlugin", template="war:/push-notifications/templates/RequestJoinSpacePlugin.gtmpl"), @TemplateConfig(pluginId="SpaceInvitationPlugin", template="war:/push-notifications/templates/SpaceInvitationPlugin.gtmpl"), @TemplateConfig(pluginId="ShareFileToUserPlugin", template="war:/push-notifications/templates/ShareDocumentToUser.gtmpl"), @TemplateConfig(pluginId="ShareFileToSpacePlugin", template="war:/push-notifications/templates/ShareDocumentToSpace.gtmpl")})
public class PushTemplateProvider
extends WebTemplateProvider {
    private final Map<PluginKey, AbstractTemplateBuilder> webTemplateBuilders = new HashMap<PluginKey, AbstractTemplateBuilder>();
    private AbstractTemplateBuilder comment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            ExoSocialActivity comment;
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("ActivityCommentPlugin"))).buildMessage(ctx);
            NotificationInfo notification = ctx.getNotificationInfo();
            boolean notHighLightComment = Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.NOT_HIGHLIGHT_COMMENT_PORPERTY.getKey()));
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            if (activity.isComment()) {
                comment = activity;
                activity = Utils.getActivityManager().getParentActivity(comment);
                notification.with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId());
                notification.with(SocialNotificationUtils.COMMENT_ID.getKey(), comment.getId());
            } else {
                comment = Utils.getActivityManager().getActivity(notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey()));
            }
            String url = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(notHighLightComment ? activity.getId() : activity.getId() + "#comment-" + comment.getId()));
            return messageInfo.subject(url).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder replyToComment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("ActivityReplyToCommentPlugin"))).buildMessage(ctx);
            NotificationInfo notification = ctx.getNotificationInfo();
            boolean notHighLightComment = Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.NOT_HIGHLIGHT_COMMENT_PORPERTY.getKey()));
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String replyToCommentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_REPLY_ID.getKey());
            String url = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(notHighLightComment ? activityId : activityId + "#comment-" + replyToCommentId));
            return messageInfo.subject(url).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder mention = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("ActivityMentionPlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getActivityUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder like = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("LikePlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getActivityUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder likeComment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("LikeCommentPlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getActivityUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder newUser = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("NewUserPlugin"))).buildMessage(ctx);
            NotificationInfo notification = ctx.getNotificationInfo();
            String remoteId = notification.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
            String url = CommonsUtils.getCurrentDomain() + LinkProvider.getUserProfileUri((String)identity.getRemoteId());
            return messageInfo.subject(url).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder postActivity = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("PostActivityPlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getActivityUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder postActivitySpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("PostActivitySpaceStreamPlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getActivityUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder relationshipReceived = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("RelationshipReceivedRequestPlugin"))).buildMessage(ctx);
            NotificationInfo notification = ctx.getNotificationInfo();
            String sender = notification.getValueOwnerParameter("sender");
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", sender, true);
            String url = CommonsUtils.getCurrentDomain() + LinkProvider.getUserProfileUri((String)identity.getRemoteId());
            return messageInfo.subject(url).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder requestJoinSpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("RequestJoinSpacePlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getSpaceUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder spaceInvitation = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = ((AbstractTemplateBuilder)PushTemplateProvider.this.webTemplateBuilders.get(new PluginKey("SpaceInvitationPlugin"))).buildMessage(ctx);
            return messageInfo.subject(PushTemplateProvider.this.getSpaceUrl(ctx)).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };

    public PushTemplateProvider(InitParams initParams) {
        super(initParams);
        this.webTemplateBuilders.putAll(this.templateBuilders);
        this.templateBuilders.put(PluginKey.key((String)"ActivityCommentPlugin"), this.comment);
        this.templateBuilders.put(PluginKey.key((String)"ActivityReplyToCommentPlugin"), this.replyToComment);
        this.templateBuilders.put(PluginKey.key((String)"ActivityMentionPlugin"), this.mention);
        this.templateBuilders.put(PluginKey.key((String)"LikePlugin"), this.like);
        this.templateBuilders.put(PluginKey.key((String)"LikeCommentPlugin"), this.likeComment);
        this.templateBuilders.put(PluginKey.key((String)"NewUserPlugin"), this.newUser);
        this.templateBuilders.put(PluginKey.key((String)"PostActivityPlugin"), this.postActivity);
        this.templateBuilders.put(PluginKey.key((String)"PostActivitySpaceStreamPlugin"), this.postActivitySpace);
        this.templateBuilders.put(PluginKey.key((String)"RelationshipReceivedRequestPlugin"), this.relationshipReceived);
        this.templateBuilders.put(PluginKey.key((String)"RequestJoinSpacePlugin"), this.requestJoinSpace);
        this.templateBuilders.put(PluginKey.key((String)"SpaceInvitationPlugin"), this.spaceInvitation);
    }

    private String getActivityUrl(NotificationContext ctx) {
        String url;
        NotificationInfo notification = ctx.getNotificationInfo();
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
        if (activity.isComment()) {
            ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
            activityId = parentActivity.getId();
            url = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(activityId + "#comment-" + activity.getId()));
        } else {
            url = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)activityId);
        }
        return url;
    }

    private String getSpaceUrl(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
        Space space = Utils.getSpaceService().getSpaceById(spaceId);
        return CommonsUtils.getCurrentDomain() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
    }
}

