/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="RequestRepliedPlugin", template="war:/notification/templates/mail/RequestReplyPlugin.gtmpl"), @TemplateConfig(pluginId="RequestStatusChangedPlugin", template="war:/notification/templates/mail/UpdateRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestCreatedPlugin", template="war:/notification/templates/mail/CreateRequestPlugin.gtmpl"), @TemplateConfig(pluginId="HRBirthdayNotificationPlugin", template="war:/notification/templates/mail/HRBirthdayNotificationPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"RequestRepliedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestStatusChangedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestCreatedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"HRBirthdayNotificationPlugin"), new TemplateBuilder());
    }

    public static String getExcerpt(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() > len) {
            str = str.substring(0, len);
            int lastSpace = str.lastIndexOf(" ");
            return (lastSpace > 0 ? str.substring(0, lastSpace) : str) + "...";
        }
        return str;
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            String birthDate;
            String toDate;
            String fromDate;
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String creator = notification.getValueOwnerParameter("creator");
            String vacationUrl = notification.getValueOwnerParameter("vacationUrl");
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            Identity author = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", creator, true);
            Profile profile = author.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)author.getRemoteId()));
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            if (vacationUrl != null) {
                templateContext.put((Object)"VACATION_URL", (Object)vacationUrl);
            }
            if ((fromDate = notification.getValueOwnerParameter("from")) != null) {
                Date theDate = new Date();
                try {
                    theDate = MailTemplateProvider.this.formatter.parse(fromDate);
                }
                catch (Exception e) {
                    log.error("Error when parsing FROM_DATE var {}", new Object[]{fromDate, e});
                }
                templateContext.put((Object)"FROM_DATE", (Object)Utils.formatDate(theDate, Utils.getUserTimezone(notification.getTo())));
            }
            if ((toDate = notification.getValueOwnerParameter("to")) != null) {
                Date theDate = new Date();
                try {
                    theDate = MailTemplateProvider.this.formatter.parse(toDate);
                }
                catch (Exception e) {
                    log.error("Error when parsing TO_DATE var {}", new Object[]{fromDate, e});
                }
                templateContext.put((Object)"TO_DATE", (Object)Utils.formatDate(theDate, Utils.getUserTimezone(notification.getTo())));
            }
            if ((birthDate = notification.getValueOwnerParameter("birthdayDate")) != null) {
                Date theDate = new Date();
                try {
                    theDate = MailTemplateProvider.this.formatter.parse(birthDate);
                }
                catch (Exception e) {
                    log.error("Error when parsing BIRTHDAY_DATE var {}", new Object[]{birthDate, e});
                }
                templateContext.put((Object)"BIRTHDAY_DATE", (Object)Utils.formatDate(theDate, Utils.getUserTimezone(notification.getTo())));
            }
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap<String, LinkedList<NotificationInfo>> map = new HashMap<String, LinkedList<NotificationInfo>>();
            for (NotificationInfo notif : notifications) {
                String activityID = notif.getValueOwnerParameter("activityId");
                LinkedList<NotificationInfo> tmp = (LinkedList<NotificationInfo>)map.get(activityID);
                if (tmp == null) {
                    tmp = new LinkedList<NotificationInfo>();
                    map.put(activityID, tmp);
                }
                tmp.add(notif);
            }
            StringBuilder sb = new StringBuilder();
            for (String activityID : map.keySet()) {
                List notifs = (List)map.get(activityID);
                NotificationInfo first = (NotificationInfo)notifs.get(0);
                String vacationUrl = first.getValueOwnerParameter("vacationUrl");
                if (notifs.size() == 1) {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                } else {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_MORE.getValue());
                }
                sb.append("<li style=\"margin:0 0 13px 14px;font-size:13px;line-height:18px;font-family:HelveticaNeue,Helvetica,Arial,sans-serif\"><div style=\"color: #333;\">");
                String digester = TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }
    }
}

