/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.ValidatorEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorDAO
extends GenericDAOJPAImpl<ValidatorEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorDAO.class);

    public List<ValidatorEntity> getValidatorsByRequestId(long id, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("validatorEntity.findAllByRequestId", ValidatorEntity.class).setParameter("requestId", (Object)id).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("validatorEntity.findAllByRequestId", ValidatorEntity.class).setParameter("requestId", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get comments with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getValidatorsByRequestIdCount(long id) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("validatorEntity.count", Long.class).setParameter("requesId", (Object)id).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests count.", (Throwable)e);
            throw e;
        }
    }

    public List<ValidatorEntity> getValidatorsByUserID(String userId) {
        try {
            return this.getEntityManager().createNamedQuery("validatorEntity.findAllByUsertId", ValidatorEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get validators ", (Throwable)e);
            throw e;
        }
    }

    public List<ValidatorEntity> getValidatorsByValidatorUserId(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("validatorEntity.findAllByValidatorUserId", ValidatorEntity.class).setParameter("validatorUserId", (Object)userId).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("validatorEntity.findAllByValidatorUserId", ValidatorEntity.class).setParameter("validatorUserId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get validators with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ValidatorEntity> getValidatorsByValidatorUserIdandRequestId(String userId, long requestId) {
        try {
            return this.getEntityManager().createNamedQuery("validatorEntity.finByValidatorUserIdandRequestId", ValidatorEntity.class).setParameter("validatorUserId", (Object)userId).setParameter("requestId", (Object)requestId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get validators", (Throwable)e);
            throw e;
        }
    }
}

