/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.CommentDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class RequestCommentedPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<CommentDTO> COMMENT = new ArgumentLiteral(CommentDTO.class, "comment");
    public static final ArgumentLiteral<Set> RECEIVERS = new ArgumentLiteral(Set.class, "receivers");
    public static final ArgumentLiteral<VacationRequestDTO> VACATION_REQUEST = new ArgumentLiteral(VacationRequestDTO.class, "vacationRequest");
    private static final Log LOG = ExoLogger.getLogger(RequestCommentedPlugin.class);
    public static final String ID = "RequestCommentedPlugin";
    IdentityManager identityManager;

    public RequestCommentedPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        CommentDTO obj = (CommentDTO)ctx.value(COMMENT);
        Set receivers = (Set)ctx.value(RECEIVERS);
        VacationRequestDTO vacationRequest = (VacationRequestDTO)ctx.value(VACATION_REQUEST);
        String userId = obj.getPosterId();
        StringBuilder activityId = new StringBuilder(userId);
        activityId.append("-").append(obj.getRequestId());
        String vacationUrl = CommonsUtils.getCurrentDomain() + "/portal/intranet/rh-management?rid=" + obj.getRequestId();
        return NotificationInfo.instance().setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("userName", vacationRequest.getUserId().toString()).with("vacationUrl", vacationUrl).with("commentText", obj.getCommentText()).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

