/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.jobs;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.rhmanagement.dto.BalanceHistoryDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.integration.notification.VacationBalanceNotificationPlugin;
import org.exoplatform.rhmanagement.services.BalanceHistoryService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateHolidaysBalanceJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(UpdateHolidaysBalanceJob.class);
    private UserDataService userDataService = (UserDataService)CommonsUtils.getService(UserDataService.class);
    private BalanceHistoryService balanceHistoryService = (BalanceHistoryService)CommonsUtils.getService(BalanceHistoryService.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.info((Object)"==================Update Holidays Balance Job started==================");
        Long start = System.currentTimeMillis();
        List<UserRHDataDTO> employees = this.userDataService.getRhDataByStatus(true, 0, 0);
        Calendar cDate = Calendar.getInstance();
        for (UserRHDataDTO employee : employees) {
            Float days;
            float holidays = employee.getHolidaysBalance();
            employee.setHolidaysBalance(holidays + 2.0f);
            if (cDate.get(2) == 0 && employee.getHolidaysBalance() > 24.0f) {
                employee.setHolidaysBalance(24.0f);
            }
            this.userDataService.save(employee);
            try {
                BalanceHistoryDTO balanceHistoryDTO = new BalanceHistoryDTO();
                balanceHistoryDTO.setUserId(employee.getUserId());
                balanceHistoryDTO.setIntialHolidaysBalance(holidays);
                balanceHistoryDTO.setIntialSickBalance(employee.getSickdaysBalance());
                balanceHistoryDTO.setHolidaysBalance(employee.getHolidaysBalance());
                balanceHistoryDTO.setSickBalance(employee.getSickdaysBalance());
                balanceHistoryDTO.setVacationType("holiday");
                balanceHistoryDTO.setVacationId(-1L);
                Float nVb = Float.valueOf(employee.getHolidaysBalance());
                balanceHistoryDTO.setDaysNumber(nVb.floatValue() - holidays);
                balanceHistoryDTO.setUpdateType("monthlyHolidayUpdate");
                balanceHistoryDTO.setUpdaterId("System");
                this.balanceHistoryService.save(balanceHistoryDTO);
            }
            catch (Exception e) {
                LOG.error((Object)"Error when adding history entry", (Throwable)e);
            }
            if (cDate.get(2) != 5 && cDate.get(2) < 8 || !((days = Float.valueOf(Utils.getEndYearBalance(employee.getHolidaysBalance()))).floatValue() > 24.0f)) continue;
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(VacationBalanceNotificationPlugin.EMPLOYEE, (Object)employee).append(VacationBalanceNotificationPlugin.DAYS_TO_CONSUME, (Object)Float.valueOf(days.floatValue() - 24.0f));
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"VacationBalanceNotificationPlugin"))).execute(ctx);
        }
        LOG.info((Object)("=============================== Update Holidays Balance Job ended in " + String.valueOf(System.currentTimeMillis() - start) + " ms ===============================."));
    }
}

