/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.ConventionalVacationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConventionalVacationDAO
extends GenericDAOJPAImpl<ConventionalVacationEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ConventionalVacationDAO.class);

    public List<ConventionalVacationEntity> getConventionalVacations(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("conventionalVacationEntity.findAll", ConventionalVacationEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("conventionalVacationEntity.findAll", ConventionalVacationEntity.class).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Conventional vacations with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getConventionalVacationsCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("conventionalVacationEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Conventional vacations count.", (Throwable)e);
            throw e;
        }
    }

    public ConventionalVacationEntity getConventionalVacationById(long id) {
        try {
            return (ConventionalVacationEntity)this.getEntityManager().createNamedQuery("conventionalVacationEntity.findConventionalVacationbyId", ConventionalVacationEntity.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Conventional vacation ", (Throwable)e);
            throw e;
        }
    }
}

