/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.rhmanagement.dto.OfficialVacationDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/rhrequest")
@Produces(value={"application/json"})
public class RequestRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RequestRestService.class);
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private VacationRequestService vacationRequestService;
    private ValidatorService validatorService;
    private OrganizationService organizationService;
    private UserDataService userDataService;
    private OfficialVacationService officialVacationService;

    public RequestRestService(IdentityManager identityManager, SpaceService spaceService, VacationRequestService vacationRequestService, ValidatorService validatorService, OrganizationService organizationService, UserDataService userDataService, OfficialVacationService officialVacationService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.vacationRequestService = vacationRequestService;
        this.validatorService = validatorService;
        this.organizationService = organizationService;
        this.userDataService = userDataService;
        this.officialVacationService = officialVacationService;
    }

    @GET
    @Path(value="users/find")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response find(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String nameToSearch, @QueryParam(value="currentUser") String currentUser) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List profiles;
            JSONArray users = new JSONArray();
            String employeesSpace = System.getProperty("exo.hrmanagement.employees.space", "exo_employees");
            Space space = this.spaceService.getSpaceByGroupId("/spaces/" + employeesSpace);
            if (space != null && (profiles = this.getSpaceMembersProfiles(space).stream().filter(a -> a.getFullName().toLowerCase().contains(nameToSearch.toLowerCase())).collect(Collectors.toList())) != null && profiles.size() > 0) {
                for (Profile profile : profiles) {
                    JSONObject user = new JSONObject();
                    user.put("value", (Object)profile.getIdentity().getRemoteId());
                    user.put("type", (Object)"user");
                    user.put("invalid", false);
                    user.put("order", (Object)"1");
                    if (profile.getAvatarUrl() != null) {
                        user.put("avatarUrl", (Object)profile.getAvatarUrl());
                    } else {
                        user.put("avatarUrl", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                    }
                    user.put("text", (Object)(profile.getFullName() + " (" + profile.getIdentity().getRemoteId() + ")"));
                    users.put((Object)user);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("options", (Object)users);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getevents")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response getEvents(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        SimpleDateFormat dt1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            List<OfficialVacationDTO> list;
            JSONObject event;
            List<ValidatorDTO> list2;
            JSONArray events = new JSONArray();
            List<VacationRequestDTO> vrs = this.vacationRequestService.getVacationRequestsByUserId(currentUser, 0, 100);
            if (vrs.size() > 0) {
                for (VacationRequestDTO vacationRequestDTO : vrs) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("id", vacationRequestDTO.getId());
                    jSONObject.put("title", (Object)vacationRequestDTO.getUserFullName());
                    jSONObject.put("start", (Object)dt1.format(vacationRequestDTO.getFromDate()));
                    jSONObject.put("end", (Object)dt1.format(vacationRequestDTO.getToDate()));
                    if ("validated".equals(vacationRequestDTO.getStatus())) {
                        jSONObject.put("backgroundColor", (Object)"green");
                    }
                    if ("approved".equals(vacationRequestDTO.getStatus())) {
                        jSONObject.put("backgroundColor", (Object)"blue");
                    }
                    if ("declined".equals(vacationRequestDTO.getStatus()) || "canceled".equals(vacationRequestDTO.getStatus())) {
                        jSONObject.put("backgroundColor", (Object)"red");
                    }
                    if ("pending".equals(vacationRequestDTO.getStatus())) {
                        jSONObject.put("backgroundColor", (Object)"orange");
                    }
                    events.put((Object)jSONObject);
                }
            }
            List<String> listEmployees = new ArrayList<String>();
            if ((listEmployees = this.userDataService.createAllSubordonatesList(currentUser, listEmployees)).size() > 0 && (vrs = this.vacationRequestService.getVacationRequestByManager(currentUser, listEmployees, 0, 100)).size() > 0) {
                for (VacationRequestDTO vacationRequestDTO : vrs) {
                    JSONObject event3 = new JSONObject();
                    event3.put("id", vacationRequestDTO.getId());
                    event3.put("title", (Object)vacationRequestDTO.getUserFullName());
                    event3.put("start", (Object)dt1.format(vacationRequestDTO.getFromDate()));
                    event3.put("end", (Object)dt1.format(vacationRequestDTO.getToDate()));
                    if ("validated".equals(vacationRequestDTO.getStatus())) {
                        event3.put("backgroundColor", (Object)"green");
                    }
                    if ("approved".equals(vacationRequestDTO.getStatus())) {
                        event3.put("backgroundColor", (Object)"blue");
                    }
                    if ("declined".equals(vacationRequestDTO.getStatus()) || "canceled".equals(vacationRequestDTO.getStatus())) {
                        event3.put("backgroundColor", (Object)"red");
                    }
                    if ("pending".equals(vacationRequestDTO.getStatus())) {
                        event3.put("backgroundColor", (Object)"orange");
                    }
                    events.put((Object)event3);
                }
            }
            if ((list2 = this.validatorService.getValidatorsByValidatorUserId(currentUser, 0, 100)).size() > 0) {
                for (ValidatorDTO validator : list2) {
                    VacationRequestDTO requestDTO = this.vacationRequestService.getVacationRequest(validator.getRequestId());
                    if (requestDTO == null) continue;
                    event = new JSONObject();
                    event.put("id", requestDTO.getId());
                    event.put("title", (Object)requestDTO.getUserFullName());
                    event.put("start", (Object)dt1.format(requestDTO.getFromDate()));
                    event.put("end", (Object)dt1.format(requestDTO.getToDate()));
                    if ("validated".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"green");
                    }
                    if ("approved".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"blue");
                    }
                    if ("declined".equals(requestDTO.getStatus()) || "canceled".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"red");
                    }
                    if ("pending".equals(requestDTO.getStatus())) {
                        event.put("backgroundColor", (Object)"orange");
                    }
                    events.put((Object)event);
                }
            }
            if ((list = this.officialVacationService.getOfficialVacations(0, 0)).size() > 0) {
                for (OfficialVacationDTO oVacation : list) {
                    try {
                        event = new JSONObject();
                        event.put("id", oVacation.getId());
                        event.put("title", (Object)oVacation.getLabel());
                        event.put("start", (Object)dt1.format(oVacation.getBeginDate()));
                        event.put("end", (Object)dt1.format(oVacation.getEndDate()));
                        event.put("backgroundColor", (Object)"grey");
                        events.put((Object)event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.officialVacationService.getOfficialVacationDays();
            return Response.ok((Object)events.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private List<Profile> getSpaceMembersProfiles(Space space) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (String userId : space.getMembers()) {
            Profile userProfile = this.identityManager.getOrCreateIdentity("organization", userId, false).getProfile();
            profiles.add(userProfile);
        }
        return profiles;
    }

    @POST
    @Path(value="createemployees")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response createEmployees(@Context HttpServletRequest request, @Context UriInfo uriInfo, List<UserRHDataDTO> emloyees) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        UserHandler uh = this.organizationService.getUserHandler();
        try {
            for (UserRHDataDTO emp : emloyees) {
                if (uh.findUserByName(emp.getUserId()) == null) continue;
                this.userDataService.save(emp);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="updatemanagers")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response updateManagers(@Context HttpServletRequest request, @Context UriInfo uriInfo, List<UserRHDataDTO> emloyees) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            for (UserRHDataDTO emp : emloyees) {
                UserRHDataDTO user = this.userDataService.getUserRHDataByUserId(emp.getUserId());
                if (user == null) continue;
                user.setHierarchicalManager(emp.getHierarchicalManager());
                user.setFunctionalManager(emp.getFunctionalManager());
                this.userDataService.save(user);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="users/exportmanagers")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response exportManagers(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            JSONArray users = new JSONArray();
            List<UserRHDataDTO> usersDTO = this.userDataService.getRhDataByStatus(true, 0, 0);
            if (usersDTO.size() > 0) {
                for (UserRHDataDTO userDTO : usersDTO) {
                    JSONObject user = new JSONObject();
                    user.put("userId", (Object)userDTO.getUserId());
                    user.put("hierarchicalManager", (Object)(userDTO.getHierarchicalManager() != null ? userDTO.getHierarchicalManager() : ""));
                    user.put("functionalManager", (Object)(userDTO.getFunctionalManager() != null ? userDTO.getFunctionalManager() : ""));
                    users.put((Object)user);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("options", (Object)users);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }
}

