/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;

public class HRContractAnniversaryNotificationPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<UserRHDataDTO> EMPLOYEE = new ArgumentLiteral(UserRHDataDTO.class, "employee");
    public static final ArgumentLiteral<String> NOTIF_TYPE = new ArgumentLiteral(String.class, "notifType");
    private static final Log LOG = ExoLogger.getLogger(HRContractAnniversaryNotificationPlugin.class);
    public static final String ID = "HRContractAnniversaryNotificationPlugin";
    IdentityManager identityManager;

    public HRContractAnniversaryNotificationPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        NotificationInfo notif = NotificationInfo.instance();
        try {
            UserRHDataDTO obj = (UserRHDataDTO)ctx.value(EMPLOYEE);
            String notifType = (String)ctx.value(NOTIF_TYPE);
            SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
            HashSet<String> receivers = new HashSet<String>();
            for (User rh : Utils.getRhManagers()) {
                receivers.add(rh.getUserName());
            }
            String userId = obj.getUserId();
            StringBuilder activityId = new StringBuilder(userId);
            activityId.append("-").append(obj.getUserId());
            notif.setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("contractAnnivDate", String.valueOf(obj.getContractStartDate().getTime())).with("activityId", activityId.toString()).key(this.getKey()).end();
        }
        catch (Exception ex) {
            LOG.error("Error when add receivers NotificationInfo user", new Object[]{ex.getMessage(), ex});
        }
        return notif;
    }
}

