/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.jobs;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.integration.notification.HRBirthdayNotificationPlugin;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NotificationsJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(NotificationsJob.class);
    private UserDataService userDataService = (UserDataService)CommonsUtils.getService(UserDataService.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.info((Object)"==================Notifications Job started==================");
        Long start = System.currentTimeMillis();
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        List<UserRHDataDTO> employees = this.userDataService.getAllRhData(0, 0);
        Calendar now = Calendar.getInstance();
        for (UserRHDataDTO employee : employees) {
            if (employee.getBirthDay() == null) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(employee.getBirthDay());
            cal.set(1, now.get(1));
            int rem = this.daysBetween(cal, now);
            if (rem != 0) continue;
            Profile userProfile = identityManager.getOrCreateIdentity("organization", employee.getUserId(), false).getProfile();
            String message = "The Birthday of " + userProfile.getFullName() + "will be in " + rem + " days";
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(HRBirthdayNotificationPlugin.EMPLOYEE, (Object)employee).append(HRBirthdayNotificationPlugin.NOTIF_TYPE, (Object)message);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"HRBirthdayNotificationPlugin"))).execute(ctx);
        }
        LOG.info((Object)("=============================== Notifications Job ended in " + String.valueOf(System.currentTimeMillis() - start) + " ms ===============================."));
    }

    public int daysBetween(Calendar d1, Calendar d2) {
        return (int)((d2.getTime().getTime() - d1.getTime().getTime()) / 86400000L);
    }
}

