/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.sirona.reporting.web.handler.TemplateHelper;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.template.Templates;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class FilteringEndpoints {
    private static final String BOOTSTRAP_CSS = "/resources/css/bootstrap.css";
    private static final String SIRONA_CSS = "/resources/css/sirona.css";
    private static final String RESOURCES = "/resources/.*";
    private ResourceLoader rl;

    public FilteringEndpoints() {
        try {
            this.rl = (ResourceLoader)ResourceLoader.class.cast(FilteringEndpoints.class.getClassLoader().loadClass((String)Templates.property("monitoring.resource.loader.class")).newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Regex(value="/resources/css/sirona.css")
    public void filterCss(TemplateHelper helper) {
        helper.renderPlain(SIRONA_CSS);
    }

    @Regex(value="/resources/css/bootstrap.css")
    public void filterBootstrapCss(TemplateHelper helper) {
        helper.renderPlain(BOOTSTRAP_CSS);
    }

    @Regex(value="/resources/.*")
    public void filterOtherResources(HttpServletRequest req) {
        InputStream is;
        String requestURI = req.getRequestURI();
        try {
            is = this.rl.getResourceStream(requestURI.substring(((String)req.getAttribute("baseUri")).length()));
        }
        catch (ResourceNotFoundException rnfe) {
            return;
        }
        try {
            int length;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            req.setAttribute("resourceCache", (Object)os);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }
}

