/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona;

import java.io.Serializable;
import org.apache.sirona.counters.Unit;

public class Role
implements Comparable<Role>,
Serializable {
    public static final Role WEB = new Role("web", Unit.Time.NANOSECOND);
    public static final Role JSP = new Role("jsp", Unit.Time.NANOSECOND);
    public static final Role JDBC = new Role("jdbc", Unit.Time.NANOSECOND);
    public static final Role PERFORMANCES = new Role("performances", Unit.Time.NANOSECOND);
    public static final Role FAILURES = new Role("failures", Unit.UNARY);
    private final String name;
    private final Unit unit;

    public Role(String name, Unit unit) {
        if (name == null) {
            throw new IllegalArgumentException("A role name is required");
        }
        if (unit == null) {
            throw new IllegalArgumentException("A role unit is required");
        }
        this.name = name;
        this.unit = unit;
    }

    public String getName() {
        return this.name;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)Role.class.cast(o);
        return this.name.equals(role.name);
    }

    @Override
    public int compareTo(Role o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "Role{name='" + this.name + '\'' + ", unit=" + this.unit + '}';
    }
}

