/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.configuration.ioc;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.AutoSet;
import org.apache.sirona.configuration.ioc.Created;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.util.ClassLoaders;

public final class IoCs {
    private static final Map<Class<?>, Object> SINGLETONS = new ConcurrentHashMap();
    private static final Collection<ToDestroy> INSTANCES = new ArrayList<ToDestroy>();
    private static Thread shutdownHook = null;

    public static <T> T[] newInstances(Class<T> api) {
        String names = Configuration.getProperty(api.getName(), null);
        if (names == null) {
            return (Object[])Array.newInstance(api, 0);
        }
        String[] split = names.split(",");
        Object[] array = (Object[])Array.newInstance(api, split.length);
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = IoCs.newInstance(api, split[i]);
                continue;
            }
            catch (Exception e) {
                throw new SironaException(e);
            }
        }
        return array;
    }

    public static synchronized <T> T findOrCreateInstance(Class<T> clazz) {
        T t = clazz.cast(SINGLETONS.get(clazz));
        if (t != null) {
            return t;
        }
        return IoCs.newInstance(clazz);
    }

    public static synchronized <T> T newInstance(Class<T> clazz) {
        try {
            String config = Configuration.getProperty(clazz.getName(), null);
            if (config == null) {
                config = clazz.isInterface() ? clazz.getPackage().getName() + ".Default" + clazz.getSimpleName() : clazz.getName();
            }
            T t = IoCs.newInstance(clazz, config);
            SINGLETONS.put(clazz, t);
            return t;
        }
        catch (Exception e) {
            throw new SironaException(e);
        }
    }

    private static <T> T newInstance(Class<T> clazz, String config) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<Object> loadedClass;
        try {
            loadedClass = ClassLoaders.current().loadClass(config);
        }
        catch (Throwable throwable) {
            loadedClass = clazz;
        }
        return clazz.cast(IoCs.internalProcessInstance(loadedClass.newInstance()));
    }

    public static <T> T processInstance(T instance) {
        try {
            return IoCs.internalProcessInstance(instance);
        }
        catch (Exception e) {
            throw new SironaException(e);
        }
    }

    private static <T> T internalProcessInstance(T instance) throws IllegalAccessException, InvocationTargetException {
        Class<?> loadedClass = instance.getClass();
        if (loadedClass.getAnnotation(AutoSet.class) != null) {
            IoCs.autoSet(instance, loadedClass);
        }
        for (Class<?> clazz = loadedClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.getAnnotation(Created.class) != null) {
                    m.setAccessible(true);
                    m.invoke(instance, new Object[0]);
                    continue;
                }
                if (m.getAnnotation(Destroying.class) == null) continue;
                m.setAccessible(true);
                if (shutdownHook == null == Configuration.is("org.apache.sirona.shutdown.hook", true)) {
                    shutdownHook = new Thread(){

                        @Override
                        public void run() {
                            IoCs.shutdown();
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
                INSTANCES.add(new ToDestroy(m, instance));
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void autoSet(T instance, Class<?> loadedClass) throws IllegalAccessException {
        for (Class<?> current = loadedClass; current != null && !current.isInterface() && !Object.class.equals(current); current = current.getSuperclass()) {
            for (Field field : loadedClass.getDeclaredFields()) {
                String value;
                if (Modifier.isFinal(field.getModifiers()) || (value = Configuration.getProperty(loadedClass.getName() + "." + field.getName(), null)) == null) continue;
                boolean acc = field.isAccessible();
                if (!acc) {
                    field.setAccessible(true);
                }
                try {
                    field.set(instance, IoCs.convertTo(field.getType(), value));
                }
                finally {
                    if (!acc) {
                        field.setAccessible(false);
                    }
                }
            }
        }
    }

    public static void setSingletonInstance(Class<?> clazz, Object instance) {
        SINGLETONS.put(clazz, instance);
    }

    public static <T> T getInstance(Class<T> clazz) {
        return clazz.cast(SINGLETONS.get(clazz));
    }

    public static void shutdown() {
        for (ToDestroy c : INSTANCES) {
            c.destroy();
        }
        INSTANCES.clear();
        SINGLETONS.clear();
    }

    private static Object convertTo(Class<?> type, String value) {
        if (String.class.equals(type)) {
            return value;
        }
        if (String[].class.equals(type)) {
            return value.split(",");
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Long.TYPE.equals(type)) {
            return Long.parseLong(value);
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.parseBoolean(value);
        }
        throw new IllegalArgumentException("Type " + type.getName() + " not supported");
    }

    private IoCs() {
    }

    private static class ToDestroy {
        private final Method method;
        private final Object target;

        public ToDestroy(Method m, Object instance) {
            this.method = m;
            this.target = instance;
        }

        public void destroy() {
            try {
                this.method.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

