/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import org.apache.sirona.spi.SPI;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.status.Validation;
import org.apache.sirona.status.ValidationFactory;
import org.apache.sirona.status.ValidationResult;

public class NodeStatusReporter {
    public synchronized NodeStatus computeStatus() {
        Validation[] validations = this.reload();
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(validations.length);
        for (Validation v : validations) {
            results.add(v.validate());
        }
        return new NodeStatus(results.toArray(new ValidationResult[results.size()]), new Date());
    }

    public synchronized Validation[] reload() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedList<Validation> val = new LinkedList<Validation>();
        for (Validation v : SPI.INSTANCE.find(Validation.class, classLoader)) {
            val.add(v);
        }
        for (ValidationFactory f : SPI.INSTANCE.find(ValidationFactory.class, classLoader)) {
            val.addAll(Arrays.asList(f.validations()));
        }
        return val.toArray(new Validation[val.size()]);
    }
}

