/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.gauge;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.store.gauge.CollectorGaugeDataStore;
import org.apache.sirona.store.gauge.GaugeDataStore;
import org.apache.sirona.store.gauge.GaugeValuesRequest;
import org.apache.sirona.store.gauge.InMemoryGaugeDataStore;

public class DelegatedCollectorGaugeDataStore
implements CollectorGaugeDataStore {
    private final ConcurrentMap<String, GaugeDataStore> dataStores = new ConcurrentHashMap<String, GaugeDataStore>();
    private final Class<? extends GaugeDataStore> delegateClass;

    public DelegatedCollectorGaugeDataStore() {
        try {
            this.delegateClass = (Class)Class.class.cast(DelegatedCollectorGaugeDataStore.class.getClassLoader().loadClass(Configuration.getProperty("org.apache.sirona.collector.gauge.store-class", InMemoryGaugeDataStore.class.getName())));
        }
        catch (ClassNotFoundException e) {
            throw new SironaException(e);
        }
    }

    protected GaugeDataStore newStore(String marker) {
        try {
            Constructor<? extends GaugeDataStore> cons = this.delegateClass.getConstructor(String.class);
            return cons.newInstance(marker);
        }
        catch (Exception e) {
            try {
                return this.delegateClass.newInstance();
            }
            catch (Exception e2) {
                throw new SironaException(e2);
            }
        }
    }

    @Override
    public SortedMap<Long, Double> getGaugeValues(GaugeValuesRequest gaugeValuesRequest, String marker) {
        GaugeDataStore gaugeDataStore = (GaugeDataStore)this.dataStores.get(marker);
        if (gaugeDataStore == null) {
            return new TreeMap<Long, Double>();
        }
        return gaugeDataStore.getGaugeValues(gaugeValuesRequest);
    }

    @Override
    public void createOrNoopGauge(Role role, String marker) {
        GaugeDataStore existing;
        GaugeDataStore gaugeDataStore = (GaugeDataStore)this.dataStores.get(marker);
        if (gaugeDataStore == null && (existing = this.dataStores.putIfAbsent(marker, gaugeDataStore = this.newStore(marker))) != null) {
            gaugeDataStore = existing;
        }
        gaugeDataStore.createOrNoopGauge(role);
    }

    @Override
    public void addToGauge(Role role, long time, double value, String marker) {
        this.createOrNoopGauge(role, marker);
        ((GaugeDataStore)this.dataStores.get(marker)).addToGauge(role, time, value);
    }

    @Override
    public Collection<String> markers() {
        return this.dataStores.keySet();
    }

    @Override
    public SortedMap<Long, Double> getGaugeValues(GaugeValuesRequest gaugeValuesRequest) {
        TreeMap<Long, Double> values = new TreeMap<Long, Double>();
        for (Map.Entry marker : this.dataStores.entrySet()) {
            SortedMap<Long, Double> gaugeValues = ((GaugeDataStore)marker.getValue()).getGaugeValues(gaugeValuesRequest);
            for (Map.Entry entry : gaugeValues.entrySet()) {
                Long key = (Long)entry.getKey();
                Double value = (Double)values.get(key);
                Double thisValue = (Double)entry.getValue();
                if (value == null) {
                    values.put(key, thisValue);
                    continue;
                }
                values.put(key, value + thisValue);
            }
        }
        return values;
    }

    @Override
    public Collection<Role> gauges() {
        HashSet<Role> roles = new HashSet<Role>();
        for (GaugeDataStore store : this.dataStores.values()) {
            roles.addAll(store.gauges());
        }
        return roles;
    }

    @Override
    public Role findGaugeRole(String name) {
        for (GaugeDataStore store : this.dataStores.values()) {
            Role role = store.findGaugeRole(name);
            if (role == null) continue;
            return role;
        }
        return null;
    }

    @Override
    public void gaugeStopped(Role gauge) {
        for (GaugeDataStore store : this.dataStores.values()) {
            store.gaugeStopped(gauge);
        }
    }

    public void reset() {
        this.dataStores.clear();
    }
}

