/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.reporting.web.handler.internal.EndpointInfo;
import org.apache.sirona.reporting.web.handler.internal.Invoker;
import org.apache.sirona.reporting.web.plugin.api.Local;
import org.apache.sirona.reporting.web.plugin.api.Plugin;
import org.apache.sirona.spi.SPI;
import org.apache.sirona.util.Environment;

public final class PluginRepository {
    public static Collection<PluginInfo> PLUGIN_INFO = new CopyOnWriteArrayList<PluginInfo>();
    public static final String ACTIVATED_FLAG = ".activated";

    private PluginRepository() {
    }

    static {
        boolean acceptLocal = !Environment.isCollector();
        for (Plugin plugin : SPI.INSTANCE.find(Plugin.class, Plugin.class.getClassLoader())) {
            if (!acceptLocal && plugin.getClass().getAnnotation(Local.class) != null) continue;
            String name = plugin.name();
            if (name == null) {
                throw new IllegalArgumentException("plugin name can't be null");
            }
            if (!Configuration.is((String)(name + ACTIVATED_FLAG), (boolean)true)) continue;
            String mapping = plugin.mapping();
            Class handler = plugin.endpoints();
            if (mapping == null) continue;
            PLUGIN_INFO.add(new PluginInfo(mapping, name, EndpointInfo.build(handler, plugin.name(), plugin.mapping())));
        }
    }

    public static class PluginInfo {
        private final String url;
        private final String name;
        private final EndpointInfo info;

        public PluginInfo(String url, String name, EndpointInfo info) {
            this.url = url;
            this.name = name;
            this.info = info;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public Map<Pattern, Invoker> getInvokers() {
            return this.info.getInvokers();
        }
    }
}

