/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.aop;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.aop.DefaultMonitorNameExtractor;
import org.apache.sirona.aop.MonitorNameExtractor;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.stopwatches.StopWatch;

public abstract class AbstractPerformanceInterceptor<T>
implements Serializable {
    private static final boolean ADAPTIVE = Configuration.is((String)"org.apache.sirona.performance.adaptive", (boolean)false);
    private static final long FORCED_ITERATION = Configuration.getInteger((String)"org.apache.sirona.performance.forced-iteration", (int)0);
    private static final long THRESHOLD = AbstractPerformanceInterceptor.duration(Configuration.getProperty((String)"org.apache.sirona.performance.threshold", null));
    private static final ActivationContext ALWAYS_ACTIVE_CONTEXT = new ActivationContext(true, 0L, 0L);
    protected static final ConcurrentMap<Object, ActivationContext> CONTEXTS = new ConcurrentHashMap<Object, ActivationContext>();
    protected MonitorNameExtractor monitorNameExtractor;

    private static long duration(String duration) {
        if (duration == null) {
            return 0L;
        }
        String[] parts = duration.split(" ");
        if (parts.length == 1) {
            return Long.parseLong(duration.trim());
        }
        if (parts.length == 2) {
            return TimeUnit.valueOf(parts[2].trim().toUpperCase(Locale.ENGLISH)).toNanos(Long.parseLong(parts[0].trim()));
        }
        return 0L;
    }

    public AbstractPerformanceInterceptor() {
        this.setMonitorNameExtractor(DefaultMonitorNameExtractor.INSTANCE);
    }

    protected Object doInvoke(T invocation) throws Throwable {
        String name = this.getCounterName(invocation);
        if (name == null) {
            return this.proceed(invocation);
        }
        Context ctx = this.before(invocation, name);
        Throwable error = null;
        try {
            Object object = this.proceed(invocation);
            return object;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (error == null) {
                ctx.stop();
            } else {
                ctx.stopWithException(error);
            }
        }
    }

    protected Context before(T invocation, String name) {
        ActivationContext context = this.doFindContext(invocation);
        try {
            StopWatch stopwatch;
            if (context.shouldExecute()) {
                Counter monitor;
                Repository repository = Repository.INSTANCE;
                if (repository == null) {
                    System.out.println("repository is null");
                }
                if ((monitor = repository.getCounter(this.getKey(invocation, name))) == null) {
                    System.out.println("monitor is null");
                }
                stopwatch = Repository.INSTANCE.start(monitor);
            } else {
                stopwatch = null;
            }
            return this.newContext(invocation, context, stopwatch);
        }
        catch (Exception e) {
            return this.newContext(invocation, context, new StopWatch(){

                public long getElapsedTime() {
                    return 0L;
                }

                public StopWatch stop() {
                    return this;
                }
            });
        }
    }

    protected Context newContext(T invocation, ActivationContext context, StopWatch stopwatch) {
        return new Context(context, stopwatch);
    }

    protected Counter.Key getKey(T invocation, String name) {
        return new Counter.Key(this.getRole(), name);
    }

    protected boolean isAdaptive() {
        return ADAPTIVE;
    }

    protected Object extractContextKey(T invocation) {
        return null;
    }

    protected ActivationContext getOrCreateContext(Object m) {
        ActivationContext c = (ActivationContext)CONTEXTS.get(m);
        if (c == null) {
            String counterName = SerializableMethod.class.isInstance(m) ? this.getCounterName(null, ((SerializableMethod)SerializableMethod.class.cast(m)).method()) : m.toString();
            return this.putAndGetActivationContext(m, new ActivationContext(true, counterName));
        }
        return c;
    }

    protected ActivationContext putAndGetActivationContext(Object m, ActivationContext newCtx) {
        ActivationContext old = CONTEXTS.putIfAbsent(m, newCtx);
        if (old != null) {
            newCtx = old;
        }
        return newCtx;
    }

    protected ActivationContext doFindContext(T invocation) {
        if (!this.isAdaptive()) {
            return ALWAYS_ACTIVE_CONTEXT;
        }
        Object m = this.extractContextKey(invocation);
        if (m != null) {
            return this.getOrCreateContext(m);
        }
        return ALWAYS_ACTIVE_CONTEXT;
    }

    protected Role getRole() {
        return Role.PERFORMANCES;
    }

    protected abstract Object proceed(T var1) throws Throwable;

    protected abstract String getCounterName(T var1);

    protected String getCounterName(Object instance, Method method) {
        return this.monitorNameExtractor.getMonitorName(instance, method);
    }

    public void setMonitorNameExtractor(MonitorNameExtractor monitorNameExtractor) {
        this.monitorNameExtractor = monitorNameExtractor;
    }

    protected static class ActivationContext
    implements Serializable {
        protected final long forceIteration;
        protected final long threshold;
        protected final boolean thresholdActive;
        protected volatile boolean active = true;
        protected volatile AtomicInteger iteration = new AtomicInteger(0);

        public ActivationContext(boolean active, long th, long it) {
            this.active = active;
            this.forceIteration = it >= 0L ? it : FORCED_ITERATION;
            this.threshold = th >= 0L ? th : THRESHOLD;
            this.thresholdActive = this.threshold > 0L;
        }

        public ActivationContext(boolean active, String name) {
            this(active, AbstractPerformanceInterceptor.duration(Configuration.getProperty((String)("org.apache.sirona.performance." + name + ".threshold"), null)), Configuration.getInteger((String)("org.apache.sirona.performance." + name + ".forced-iteration"), (int)-1));
        }

        public boolean isForcedIteration() {
            return (long)this.iteration.incrementAndGet() > this.forceIteration;
        }

        protected long getThreshold() {
            return this.threshold;
        }

        protected boolean isThresholdActive() {
            return this.thresholdActive;
        }

        public boolean isActive() {
            return this.active;
        }

        public void reset() {
            this.active = false;
            this.iteration.set(0);
        }

        public boolean shouldExecute() {
            return this.isActive() || this.isForcedIteration();
        }

        public void elapsedTime(long elapsedTime) {
            if (this.isThresholdActive() && elapsedTime < this.getThreshold()) {
                this.reset();
            }
        }
    }

    protected static class SerializableMethod
    implements Serializable {
        protected final String clazz;
        protected final String method;
        protected transient Method realMethod;
        protected final int hashCode;

        public SerializableMethod(String clazz, String method, Method reflectMethod) {
            this.clazz = clazz;
            this.method = method;
            this.realMethod = reflectMethod;
            this.hashCode = reflectMethod.hashCode();
        }

        public SerializableMethod(Method m) {
            this(m.getDeclaringClass().getName(), m.getName(), m);
        }

        public Method method() {
            if (this.realMethod == null) {
                try {
                    for (Class<?> declaring = Thread.currentThread().getContextClassLoader().loadClass(this.clazz); declaring != null; declaring = declaring.getSuperclass()) {
                        for (Method m : declaring.getDeclaredMethods()) {
                            if (!m.getName().equals(this.method)) continue;
                            this.realMethod = m;
                            return this.realMethod;
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new SironaException(e.getMessage(), (Throwable)e);
                }
            }
            return this.realMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableMethod that = (SerializableMethod)SerializableMethod.class.cast(o);
            if (this.method != null && that.method != null) {
                return this.method.equals(that.method);
            }
            return this.hashCode == that.hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class Context {
        private static final int MAX_LENGTH = Configuration.getInteger((String)"org.apache.sirona.performance.exception.max-length", (int)100);
        protected final ActivationContext activationContext;
        protected final StopWatch stopWatch;

        public Context(ActivationContext activationContext, StopWatch stopWatch) {
            this.activationContext = activationContext;
            this.stopWatch = stopWatch;
        }

        public void stop() {
            if (this.stopWatch != null) {
                long elapsedTime = this.stopWatch.stop().getElapsedTime();
                this.activationContext.elapsedTime(elapsedTime);
            }
        }

        public void stopWithException(Throwable error) {
            if (this.stopWatch != null) {
                this.stopWatch.stop();
                long elapsedTime = this.stopWatch.getElapsedTime();
                if (error != null) {
                    Repository.INSTANCE.getCounter(new Counter.Key(Role.FAILURES, error.getClass().getName() + ":" + (error.getMessage() != null ? error.getMessage() : ""))).add((double)elapsedTime);
                }
                this.activationContext.elapsedTime(elapsedTime);
            }
        }
    }
}

