/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.web.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.gauges.Gauge;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.stopwatches.StopWatch;
import org.apache.sirona.web.session.SessionGauge;

public class SironaSessionListener
implements HttpSessionListener,
ServletContextListener {
    private final Map<String, StopWatch> watches = new ConcurrentHashMap<String, StopWatch>();
    private final AtomicLong sessionNumber = new AtomicLong(0L);
    private Counter counter;
    private SessionGauge gauge;

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        StopWatch watch = Repository.INSTANCE.start(this.counter);
        this.watches.put(httpSessionEvent.getSession().getId(), watch);
        this.sessionNumber.incrementAndGet();
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        StopWatch watch = this.watches.remove(httpSessionEvent.getSession().getId());
        if (watch != null) {
            watch.stop();
        }
        this.sessionNumber.decrementAndGet();
    }

    public void contextInitialized(ServletContextEvent sce) {
        String contextPath = sce.getServletContext().getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        this.counter = Repository.INSTANCE.getCounter(new Counter.Key(new Role("session-durations", Unit.Time.NANOSECOND), "session-durations-" + contextPath));
        this.gauge = new SessionGauge(contextPath, this.sessionNumber);
        Repository.INSTANCE.addGauge((Gauge)this.gauge);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Repository.INSTANCE.stopGauge((Gauge)this.gauge);
    }
}

