/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.counters;

import org.apache.sirona.counters.Counter;

public enum MetricData {
    Hits{

        @Override
        public double value(Counter counter) {
            return counter.getHits();
        }

        @Override
        public boolean isTime() {
            return false;
        }
    }
    ,
    Max{

        @Override
        public double value(Counter counter) {
            return counter.getMax();
        }

        @Override
        public boolean isTime() {
            return true;
        }
    }
    ,
    Mean{

        @Override
        public double value(Counter counter) {
            return counter.getMean();
        }

        @Override
        public boolean isTime() {
            return true;
        }
    }
    ,
    Min{

        @Override
        public double value(Counter counter) {
            return counter.getMin();
        }

        @Override
        public boolean isTime() {
            return true;
        }
    }
    ,
    StandardDeviation{

        @Override
        public double value(Counter counter) {
            return counter.getStandardDeviation();
        }

        @Override
        public boolean isTime() {
            return false;
        }
    }
    ,
    Sum{

        @Override
        public double value(Counter counter) {
            return counter.getSum();
        }

        @Override
        public boolean isTime() {
            return true;
        }
    }
    ,
    Variance{

        @Override
        public double value(Counter counter) {
            return counter.getVariance();
        }

        @Override
        public boolean isTime() {
            return false;
        }
    }
    ,
    Value{

        @Override
        public double value(Counter counter) {
            return counter.getSum();
        }

        @Override
        public boolean isTime() {
            return true;
        }
    }
    ,
    Concurrency{

        @Override
        public double value(Counter counter) {
            return counter.currentConcurrency().get();
        }

        @Override
        public boolean isTime() {
            return false;
        }
    }
    ,
    MaxConcurrency{

        @Override
        public double value(Counter counter) {
            return counter.getMaxConcurrency();
        }

        @Override
        public boolean isTime() {
            return false;
        }
    };


    public abstract double value(Counter var1);

    public abstract boolean isTime();
}

