/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.gauges;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.sirona.Role;
import org.apache.sirona.gauges.GaugeFactory;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.spi.SPI;

public interface Gauge {
    public Role role();

    public double value();

    public static class LoaderHelper {
        private LinkedList<Gauge> gauges = new LinkedList();

        public LoaderHelper(boolean excludeParent, Collection<? extends Gauge> manualGauges, String ... includedPrefixes) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (Gauge gauge : manualGauges) {
                this.addGauge(gauge);
            }
            for (Gauge gauge : SPI.INSTANCE.find(Gauge.class, classLoader)) {
                this.addGaugeIfNecessary(classLoader, gauge, excludeParent, includedPrefixes);
            }
            for (GaugeFactory gaugeFactory : SPI.INSTANCE.find(GaugeFactory.class, classLoader)) {
                Gauge[] list = gaugeFactory.gauges();
                if (list == null) continue;
                for (Gauge g : list) {
                    this.addGaugeIfNecessary(classLoader, g, excludeParent, includedPrefixes);
                }
            }
        }

        public LoaderHelper(boolean excludeParent, String ... includedPrefixes) {
            this(excludeParent, Collections.emptyList(), includedPrefixes);
        }

        private void addGaugeIfNecessary(ClassLoader classLoader, Gauge g, boolean excludeParent, String ... prefixes) {
            Class<?> gaugeClass = g.getClass();
            if (!excludeParent || gaugeClass.getClassLoader() == classLoader) {
                if (prefixes != null && prefixes.length > 0) {
                    boolean found = false;
                    for (String p : prefixes) {
                        if (!gaugeClass.getName().startsWith(p.trim())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return;
                    }
                }
                this.addGauge(g);
            }
        }

        private void addGauge(Gauge g) {
            Repository.INSTANCE.addGauge(g);
            this.gauges.add(g);
        }

        public void destroy() {
            for (Gauge gauge : this.gauges) {
                Repository.INSTANCE.stopGauge(gauge);
            }
            this.gauges.clear();
        }
    }
}

