/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.thread;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;

public class ThreadEndpoints {
    @Regex
    public Template home() {
        return new Template("threads/threads.vm", new MapBuilder().set((Object)"threads", ThreadEndpoints.listThreads()).build());
    }

    @Regex(value="/([^/]*)")
    public Template dump(String name) {
        Thread thread = ThreadEndpoints.findThread(new String(Base64.decodeBase64((String)name)));
        if (thread == null) {
            return new Template("templates/threads/thread.vm", new MapBuilder().set((Object)"state", (Object)"Not found").build(), false);
        }
        return new Template("templates/threads/thread.vm", new MapBuilder().set((Object)"state", (Object)thread.getState().name()).set((Object)"dump", (Object)StringEscapeUtils.escapeHtml4((String)ThreadEndpoints.dump(thread))).build(), false);
    }

    private static Thread findThread(String name) {
        int count = Thread.activeCount();
        Thread[] threads = new Thread[count];
        count = Thread.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            if (!threads[i].getName().equals(name)) continue;
            return threads[i];
        }
        return null;
    }

    private static String dump(Thread thread) {
        StackTraceElement[] stack = thread.getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : stack) {
            builder.append(element.toString()).append("\n");
        }
        return builder.toString();
    }

    private static Map<String, String> listThreads() {
        TreeMap<String, String> out = new TreeMap<String, String>();
        int count = Thread.activeCount();
        Thread[] threads = new Thread[count];
        count = Thread.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            String name = threads[i].getName();
            out.put(name, Base64.encodeBase64URLSafeString((byte[])name.getBytes()));
        }
        return out;
    }
}

