/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.counters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.MetricData;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.counters.CounterInfo;
import org.apache.sirona.reporting.web.counters.KeyInfo;
import org.apache.sirona.repositories.Repository;

@Path(value="/counters")
public class CountersService {
    @GET
    @Produces(value={"application/json", "application/xml"})
    public List<CounterInfo> all(@QueryParam(value="unit") String unitName) {
        Collection counters = Repository.INSTANCE.counters();
        ArrayList<CounterInfo> out = new ArrayList<CounterInfo>(counters.size());
        Unit unit = null;
        if (unitName != null) {
            unit = Unit.get((String)unitName);
        }
        for (Counter counter : counters) {
            Unit currentUnit = counter.getKey().getRole().getUnit();
            if (unit == null) {
                out.add(new CounterInfo(new KeyInfo(counter.getKey()), MetricData.Hits.value(counter), MetricData.Max.value(counter), MetricData.Mean.value(counter), MetricData.Min.value(counter), MetricData.StandardDeviation.value(counter), MetricData.Sum.value(counter), MetricData.Variance.value(counter), MetricData.Concurrency.value(counter), MetricData.MaxConcurrency.value(counter)));
                continue;
            }
            out.add(new CounterInfo(new KeyInfo(counter.getKey()).unitName(unit.getName()), MetricData.Hits.value(counter), unit.convert(MetricData.Max.value(counter), currentUnit), unit.convert(MetricData.Mean.value(counter), currentUnit), unit.convert(MetricData.Min.value(counter), currentUnit), unit.convert(MetricData.StandardDeviation.value(counter), currentUnit), unit.convert(MetricData.Sum.value(counter), currentUnit), unit.convert(MetricData.Variance.value(counter), currentUnit), MetricData.Concurrency.value(counter), MetricData.MaxConcurrency.value(counter)));
        }
        return out;
    }

    @GET
    @Path(value="/{name}/{unitName}")
    @Produces(value={"application/json", "application/xml"})
    public CounterInfo find(@PathParam(value="name") String name, @PathParam(value="unitName") String unit) {
        Counter counter = Repository.INSTANCE.getCounter(new Counter.Key(new Role(name, Unit.get((String)unit)), name));
        return counter == null ? null : new CounterInfo(new KeyInfo(counter.getKey()), MetricData.Hits.value(counter), MetricData.Max.value(counter), MetricData.Mean.value(counter), MetricData.Min.value(counter), MetricData.StandardDeviation.value(counter), MetricData.Sum.value(counter), MetricData.Variance.value(counter), MetricData.Concurrency.value(counter), MetricData.MaxConcurrency.value(counter));
    }
}

