/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.codec.binary.Base64;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.reporting.web.jmx.JMXInvocationRequest;
import org.apache.sirona.reporting.web.jmx.JMXInvocationResult;
import org.apache.sirona.reporting.web.jmx.JMXNode;
import org.apache.sirona.reporting.web.jmx.MBeanAttribute;
import org.apache.sirona.reporting.web.jmx.MBeanInformations;
import org.apache.sirona.reporting.web.jmx.MBeanOperation;
import org.apache.sirona.reporting.web.jmx.MBeanParameter;
import org.apache.sirona.util.ClassLoaders;

@Path(value="/jmx")
public class JMXServices {
    private final MBeanServerConnection server = ManagementFactory.getPlatformMBeanServer();
    private static final String EMPTY_STRING = "";
    private static final boolean METHOD_INVOCATION_ALLOWED = Configuration.is((String)"org.apache.sirona.jmx.method.allowed", (boolean)true);
    private static final Map<String, Class<?>> WRAPPERS = new HashMap();

    @GET
    @Produces(value={"application/json", "application/xml"})
    public JMXNode root() throws IOException {
        JMXNode jmxNode = this.buildJmxTree();
        return jmxNode;
    }

    @GET
    @Path(value="/{encodedName}")
    @Produces(value={"application/json", "application/xml"})
    public MBeanInformations find(@PathParam(value="encodedName") String encodedName) throws IOException, MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        ObjectName name = new ObjectName(new String(Base64.decodeBase64((String)encodedName)));
        MBeanInfo info = this.server.getMBeanInfo(name);
        MBeanInformations mBeanInformations = new MBeanInformations(name.toString(), Base64.encodeBase64URLSafeString((byte[])name.toString().getBytes()), info.getClassName(), info.getDescription(), new ArrayList<MBeanAttribute>(this.attributes(name, info)), new ArrayList<MBeanOperation>(this.operations(info)));
        return mBeanInformations;
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public JMXInvocationResult invoke(JMXInvocationRequest request) {
        if (!METHOD_INVOCATION_ALLOWED) {
            throw new SironaException("Method invocation not allowed");
        }
        try {
            ObjectName name = new ObjectName(new String(Base64.decodeBase64((String)request.getMbeanEncodedName())));
            MBeanInfo info = this.server.getMBeanInfo(name);
            for (MBeanOperationInfo op : info.getOperations()) {
                if (!op.getName().equals(request.getOperationName())) continue;
                MBeanParameterInfo[] signature = op.getSignature();
                String[] sign = new String[signature.length];
                for (int i = 0; i < sign.length; ++i) {
                    sign[i] = signature[i].getType();
                }
                Object result = this.server.invoke(name, request.getOperationName(), this.convertParams(signature, request.getParameters()), sign);
                return JMXServices.value(result);
            }
        }
        catch (Exception e) {
            return new JMXInvocationResult().errorMessage(e.getMessage());
        }
        return new JMXInvocationResult().errorMessage(request.getOperationName() + " not found");
    }

    private Object[] convertParams(MBeanParameterInfo[] signature, List<String> params) {
        if (params == null) {
            return null;
        }
        Object[] convertedParams = new Object[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            convertedParams[i] = i < params.size() ? JMXServices.convert(signature[i].getType(), params.get(i)) : null;
        }
        return convertedParams;
    }

    public static Object convert(String type, String value) {
        try {
            if (WRAPPERS.containsKey(type)) {
                if (type.equals(Character.TYPE.getName())) {
                    return Character.valueOf(value.charAt(0));
                }
                return JMXServices.tryStringConstructor(WRAPPERS.get(type).getName(), value);
            }
            if (type.equals(Character.class.getName())) {
                return Character.valueOf(value.charAt(0));
            }
            if (Number.class.isAssignableFrom(ClassLoaders.current().loadClass(type))) {
                return JMXServices.toNumber(value);
            }
            if (value == null || value.equals("null")) {
                return null;
            }
            return JMXServices.tryStringConstructor(type, value);
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    private static Number toNumber(String value) throws NumberFormatException {
        char lastChar = Character.toLowerCase(value.charAt(value.length() - 1));
        if (lastChar == 'd') {
            return Double.valueOf(value.substring(0, value.length() - 1));
        }
        if (lastChar == 'l') {
            return Long.valueOf(value.substring(0, value.length() - 1));
        }
        if (lastChar == 'f') {
            return Float.valueOf(value.substring(0, value.length() - 1));
        }
        for (Class clazz : new Class[]{Integer.class, Long.class, Double.class}) {
            try {
                return (Number)Number.class.cast(clazz.getMethod("valueOf", String.class).invoke(null, value));
            }
            catch (Exception exception) {
            }
        }
        throw new SironaException(value + " is not a number");
    }

    private static Object tryStringConstructor(String type, String value) throws Exception {
        return ClassLoaders.current().loadClass(type).getConstructor(String.class).newInstance(value);
    }

    private JMXNode buildJmxTree() throws IOException {
        JMXNode root = new JMXNode("/");
        for (ObjectInstance instance : this.server.queryMBeans(null, null)) {
            ObjectName objectName = instance.getObjectName();
            JMXNode.addNode(root, objectName.getDomain(), objectName.getKeyPropertyListString());
        }
        return root;
    }

    private Collection<MBeanOperation> operations(MBeanInfo info) {
        LinkedList<MBeanOperation> operations = new LinkedList<MBeanOperation>();
        for (MBeanOperationInfo operationInfo : info.getOperations()) {
            MBeanOperation mBeanOperation = new MBeanOperation(operationInfo.getName(), operationInfo.getReturnType());
            for (MBeanParameterInfo param : operationInfo.getSignature()) {
                mBeanOperation.getParameters().add(new MBeanParameter(param.getName(), param.getType()));
            }
            operations.add(mBeanOperation);
        }
        return operations;
    }

    private Collection<MBeanAttribute> attributes(ObjectName name, MBeanInfo info) {
        LinkedList<MBeanAttribute> list = new LinkedList<MBeanAttribute>();
        for (MBeanAttributeInfo attribute : info.getAttributes()) {
            Object value;
            try {
                value = this.server.getAttribute(name, attribute.getName());
            }
            catch (Exception e) {
                value = e.getMessage();
            }
            list.add(new MBeanAttribute(attribute.getName(), JMXServices.nullProtection(attribute.getType()), JMXServices.nullProtection(attribute.getDescription()), value == null ? EMPTY_STRING : value.toString()));
        }
        return list;
    }

    public static String nullProtection(String value) {
        return value == null ? EMPTY_STRING : value;
    }

    private static JMXInvocationResult value(Object value) {
        try {
            if (value == null) {
                return new JMXInvocationResult();
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                if (length == 0) {
                    return new JMXInvocationResult();
                }
                ArrayList<String> results = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    Object o = Array.get(value, i);
                    if (o == null) continue;
                    results.add(o.toString());
                }
                return new JMXInvocationResult().results(results);
            }
            if (Collection.class.isInstance(value)) {
                ArrayList<String> results = new ArrayList<String>();
                for (Object o : (Collection)Collection.class.cast(value)) {
                    if (o == null) continue;
                    results.add(o.toString());
                }
                return new JMXInvocationResult().results(results);
            }
            if (TabularData.class.isInstance(value)) {
                TabularData td = (TabularData)TabularData.class.cast(value);
                ArrayList<String> results = new ArrayList<String>();
                for (Object type : td.keySet()) {
                    List values = (List)type;
                    CompositeData data = td.get(values.toArray(new Object[values.size()]));
                    for (String k : data.getCompositeType().keySet()) {
                        Object o = data.get(k);
                        if (o == null) continue;
                        results.add(o.toString());
                    }
                }
                return new JMXInvocationResult().results(results);
            }
            if (CompositeData.class.isInstance(value)) {
                CompositeData cd = (CompositeData)CompositeData.class.cast(value);
                Set<String> keys = cd.getCompositeType().keySet();
                HashMap<String, String> results = new HashMap<String, String>();
                Iterator<String> type = keys.iterator();
                while (type.hasNext()) {
                    String type2;
                    Object o = cd.get(type2 = type.next());
                    results.put(type2, o != null ? o.toString() : EMPTY_STRING);
                }
                return new JMXInvocationResult().mapResult(results);
            }
            if (Map.class.isInstance(value)) {
                Map map = (Map)Map.class.cast(value);
                HashMap<String, String> results = new HashMap<String, String>();
                for (Map.Entry entry : map.entrySet()) {
                    results.put(entry.getKey().toString(), entry.getValue().toString());
                }
                return new JMXInvocationResult().mapResult(results);
            }
            return new JMXInvocationResult().results(Collections.singletonList(value.toString()));
        }
        catch (Exception e) {
            throw new SironaException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        for (Class c : Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class)) {
            try {
                Field f = c.getField("TYPE");
                Class p = (Class)f.get(null);
                WRAPPERS.put(p.getName(), c);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

