/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.jvm;

import java.util.SortedMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.sirona.gauges.jvm.ActiveThreadGauge;
import org.apache.sirona.gauges.jvm.CPUGauge;
import org.apache.sirona.gauges.jvm.UsedMemoryGauge;
import org.apache.sirona.gauges.jvm.UsedNonHeapMemoryGauge;
import org.apache.sirona.reporting.web.Graph;
import org.apache.sirona.repositories.Repository;

@Path(value="/jvmreports")
public class JvmReports {
    @GET
    @Path(value="/cpu/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph cpu(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, CPUGauge.CPU);
        return new Graph("CPU Usage", "#317eac", gaugeValues);
    }

    @GET
    @Path(value="/memory/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph memory(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, UsedMemoryGauge.USED_MEMORY);
        return new Graph("Used Memory", "#317eac", gaugeValues);
    }

    @GET
    @Path(value="/nonheapmemory/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph nonHeapmemory(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, UsedNonHeapMemoryGauge.USED_NONHEAPMEMORY);
        return new Graph("Used Non Heap Memory", "#317eac", gaugeValues);
    }

    @GET
    @Path(value="/activethreads/{start}/{end}")
    @Produces(value={"application/json", "application/xml"})
    public Graph activeThreads(@PathParam(value="start") long start, @PathParam(value="end") long end) {
        SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, ActiveThreadGauge.ACTIVE_THREAD);
        return new Graph("Active Thread Count", "#317eac", gaugeValues);
    }
}

