/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.status;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.sirona.reporting.web.status.ApplicationStatuses;
import org.apache.sirona.reporting.web.status.NodeStatusInfo;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.status.NodeStatus;

@Path(value="/status")
public class StatusService {
    private static final String DEFAULT_ROOT = "-";
    private static final String APP_DELIMITER = "#";

    @GET
    @Produces(value={"application/json", "application/xml"})
    public List<ApplicationStatuses> all() {
        HashMap<String, TreeMap<String, NodeStatusInfo>> statusesByApp = new HashMap<String, TreeMap<String, NodeStatusInfo>>();
        for (Map.Entry entry : Repository.INSTANCE.statuses().entrySet()) {
            String key = (String)entry.getKey();
            String[] segments = key.contains(APP_DELIMITER) ? key.split(APP_DELIMITER) : new String[]{DEFAULT_ROOT, key};
            TreeMap<String, NodeStatusInfo> statusesOfTheApp = (TreeMap<String, NodeStatusInfo>)statusesByApp.get(segments[0]);
            if (statusesOfTheApp == null) {
                statusesOfTheApp = new TreeMap<String, NodeStatusInfo>();
                statusesByApp.put(segments[0], statusesOfTheApp);
            }
            statusesOfTheApp.put(segments[1], new NodeStatusInfo(segments[1], (NodeStatus)entry.getValue()));
        }
        ArrayList<ApplicationStatuses> applicationStatuseses = new ArrayList<ApplicationStatuses>(statusesByApp.size());
        for (Map.Entry entry : statusesByApp.entrySet()) {
            applicationStatuseses.add(new ApplicationStatuses((String)entry.getKey(), ((Map)entry.getValue()).values()));
        }
        return applicationStatuseses;
    }

    @GET
    @Path(value="/{node}")
    @Produces(value={"application/json", "application/xml"})
    public NodeStatusInfo find(@PathParam(value="node") String node) {
        NodeStatus nodeStatus = (NodeStatus)Repository.INSTANCE.statuses().get(node);
        return new NodeStatusInfo(node, nodeStatus);
    }
}

