/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.threads;

import java.util.Collection;
import java.util.TreeSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.codec.binary.Base64;
import org.apache.sirona.reporting.web.threads.ThreadDump;
import org.apache.sirona.reporting.web.threads.ThreadInfo;

@Path(value="/threads")
public class ThreadsReports {
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<ThreadInfo> all() {
        return ThreadsReports.listThreads();
    }

    @GET
    @Path(value="/{threadencodedName}")
    @Produces(value={"application/json", "application/xml"})
    public ThreadDump getThread(@PathParam(value="threadencodedName") String threadencodedName) {
        Thread thread = ThreadsReports.findThread(threadencodedName);
        if (thread == null) {
            return null;
        }
        return new ThreadDump(thread.getState().name(), ThreadsReports.dump(thread));
    }

    private static Thread findThread(String threadencodedName) {
        int count = Thread.activeCount();
        Thread[] threads = new Thread[count];
        count = Thread.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            if (!Base64.encodeBase64URLSafeString((byte[])threads[i].getName().getBytes()).equals(threadencodedName)) continue;
            return threads[i];
        }
        return null;
    }

    private static String dump(Thread thread) {
        StackTraceElement[] stack = thread.getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : stack) {
            builder.append(element.toString()).append("\n");
        }
        return builder.toString();
    }

    private static Collection<ThreadInfo> listThreads() {
        TreeSet<ThreadInfo> out = new TreeSet<ThreadInfo>(ThreadInfo.COMPARATOR);
        int count = Thread.activeCount();
        Thread[] threads = new Thread[count];
        count = Thread.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            String name = threads[i].getName();
            out.add(new ThreadInfo(name, Base64.encodeBase64URLSafeString((byte[])name.getBytes())));
        }
        return out;
    }
}

