/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.memory.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sirona.pathtracking.PathCallInformation;
import org.apache.sirona.pathtracking.PathTrackingEntry;
import org.apache.sirona.pathtracking.PathTrackingEntryComparator;
import org.apache.sirona.store.memory.tracking.UnsafeUtils;
import org.apache.sirona.store.tracking.AbstractPathTrackingDataStore;
import org.apache.sirona.store.tracking.CollectorPathTrackingDataStore;
import org.apache.sirona.store.tracking.PathTrackingDataStore;
import org.apache.sirona.util.SerializeUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class InMemoryPathTrackingDataStore
extends AbstractPathTrackingDataStore
implements PathTrackingDataStore,
CollectorPathTrackingDataStore {
    private ConcurrentMap<String, List<Pointer>> pathTrackingEntries = new ConcurrentHashMap<String, List<Pointer>>(50);

    public void store(PathTrackingEntry pathTrackingEntry) {
        this.store(Collections.singletonList(pathTrackingEntry));
    }

    public void store(Collection<PathTrackingEntry> pathTrackingEntries) {
        Collection<Object> entriesList;
        if (pathTrackingEntries == null) {
            return;
        }
        HashMap entries = new HashMap();
        for (PathTrackingEntry pathTrackingEntry : pathTrackingEntries) {
            entriesList = (HashSet<PathTrackingEntry>)entries.get(pathTrackingEntry.getTrackingId());
            if (entriesList == null) {
                entriesList = new HashSet<PathTrackingEntry>();
            }
            entriesList.add(pathTrackingEntry);
            entries.put(pathTrackingEntry.getTrackingId(), entriesList);
        }
        for (Map.Entry entry : entries.entrySet()) {
            entriesList = (List)this.pathTrackingEntries.get(entry.getKey());
            if (entriesList == null) {
                entriesList = new CopyOnWriteArrayList();
            }
            entriesList.addAll(this.serialize((Collection)entry.getValue()));
            this.pathTrackingEntries.put((String)entry.getKey(), (List<Pointer>)entriesList);
        }
    }

    public Collection<PathTrackingEntry> retrieve(String trackingId) {
        List buffers = (List)this.pathTrackingEntries.get(trackingId);
        return this.deserialize(buffers);
    }

    public Collection<PathCallInformation> retrieveTrackingIds(Date startTime, Date endTime) {
        TreeSet<PathCallInformation> trackingIds = new TreeSet<PathCallInformation>(PathCallInformation.COMPARATOR);
        for (List buffers : this.pathTrackingEntries.values()) {
            PathTrackingEntry first;
            if (this.pathTrackingEntries.isEmpty() || (first = (PathTrackingEntry)SerializeUtils.deserialize((byte[])this.readBytes((Pointer)buffers.iterator().next()), PathTrackingEntry.class)).getStartTime() / 1000000L <= startTime.getTime() || first.getStartTime() / 1000000L >= endTime.getTime()) continue;
            trackingIds.add(new PathCallInformation(first.getTrackingId(), new Date(startTime.getTime() / 1000000L)));
        }
        return trackingIds;
    }

    private Collection<PathTrackingEntry> deserialize(List<Pointer> buffers) {
        ArrayList<PathTrackingEntry> entries = new ArrayList<PathTrackingEntry>(buffers.size());
        for (Pointer pointer : buffers) {
            byte[] bytes = this.readBytes(pointer);
            PathTrackingEntry entry = (PathTrackingEntry)SerializeUtils.deserialize((byte[])bytes, PathTrackingEntry.class);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    @IgnoreJRERequirement
    public byte[] readBytes(Pointer pointer) {
        byte[] bytes = new byte[pointer.size];
        int length = pointer.size;
        long offset = pointer.offheapPointer;
        for (int pos = 0; pos < length; ++pos) {
            bytes[pos] = UnsafeUtils.getUnsafe().getByte((long)pos + offset);
        }
        return bytes;
    }

    @IgnoreJRERequirement
    private List<Pointer> serialize(Collection<PathTrackingEntry> entries) {
        ArrayList<Pointer> buffers = new ArrayList<Pointer>(entries.size());
        for (PathTrackingEntry entry : entries) {
            byte[] bytes = SerializeUtils.serialize((Object)entry);
            if (bytes == null) continue;
            long offheapPointer = UnsafeUtils.getUnsafe().allocateMemory(bytes.length);
            Pointer pointer = new Pointer();
            pointer.offheapPointer = offheapPointer;
            pointer.size = bytes.length;
            int size = bytes.length;
            for (int i = 0; i < size; ++i) {
                UnsafeUtils.getUnsafe().putByte(offheapPointer + (long)i, bytes[i]);
            }
            buffers.add(pointer);
        }
        return buffers;
    }

    public void clearEntries() {
        ArrayList entriesToRemove = new ArrayList();
        for (Map.Entry entry : this.pathTrackingEntries.entrySet()) {
            boolean allFree = true;
            for (Pointer pointer : (List)entry.getValue()) {
                if (pointer.isFree()) continue;
                allFree = false;
            }
            if (!allFree) continue;
            entriesToRemove.add(entry.getKey());
        }
        for (String key : entriesToRemove) {
            this.pathTrackingEntries.remove(key);
        }
    }

    protected Map<String, Set<PathTrackingEntry>> getPathTrackingEntries() {
        HashMap<String, Set<PathTrackingEntry>> entries = new HashMap<String, Set<PathTrackingEntry>>(this.pathTrackingEntries.size());
        for (Map.Entry entry : this.pathTrackingEntries.entrySet()) {
            TreeSet<PathTrackingEntry> pathTrackingEntries = new TreeSet<PathTrackingEntry>((Comparator<PathTrackingEntry>)PathTrackingEntryComparator.INSTANCE);
            pathTrackingEntries.addAll(this.deserialize((List)entry.getValue()));
            entries.put((String)entry.getKey(), (Set<PathTrackingEntry>)pathTrackingEntries);
        }
        return entries;
    }

    protected Map<String, List<Pointer>> getPointers() {
        return this.pathTrackingEntries;
    }

    public static class Pointer {
        int size;
        long offheapPointer;
        boolean free;

        public int getSize() {
            return this.size;
        }

        public long getOffheapPointer() {
            return this.offheapPointer;
        }

        @IgnoreJRERequirement
        public void freeMemory() {
            if (!this.free) {
                UnsafeUtils.getUnsafe().freeMemory(this.offheapPointer);
                this.free = true;
            }
        }

        public boolean isFree() {
            return this.free;
        }
    }
}

