/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.alert;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.alert.AlertListener;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.status.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlerterSupport {
    protected final Collection<AlertListener> listeners = new CopyOnWriteArraySet<AlertListener>();

    public void notify(Map<String, NodeStatus> nodeStatus) {
        if (nodeStatus == null) {
            return;
        }
        for (Map.Entry<String, NodeStatus> entry : nodeStatus.entrySet()) {
            NodeStatus status = entry.getValue();
            if (status.getStatus() == Status.OK) continue;
            AlertListener.Alert alert = new AlertListener.Alert(entry.getKey(), status);
            for (AlertListener listener : this.listeners) {
                try {
                    listener.onAlert(alert);
                }
                catch (RuntimeException ex) {
                    Logger.getLogger(AlerterSupport.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    public void addAlerter(AlertListener listener) {
        this.listeners.add(listener);
    }

    public void removeAlerter(AlertListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasAlerter() {
        return !this.listeners.isEmpty();
    }
}

